/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.util;

import com.azure.ai.formrecognizer.models.AnalyzedDocument;
import com.azure.ai.formrecognizer.models.BoundingRegion;
import com.azure.ai.formrecognizer.models.DocumentField;
import com.azure.ai.formrecognizer.models.DocumentSpan;
import java.util.List;
import java.util.Map;

public final class AnalyzedDocumentHelper {
    private static AnalyzedDocumentAccessor accessor;

    private AnalyzedDocumentHelper() {
    }

    public static void setAccessor(AnalyzedDocumentAccessor analyzedDocumentAccessor) {
        accessor = analyzedDocumentAccessor;
    }

    static void setDocType(AnalyzedDocument analyzedDocument, String docType) {
        accessor.setDocType(analyzedDocument, docType);
    }

    static void setBoundingRegions(AnalyzedDocument analyzedDocument, List<BoundingRegion> boundingRegions) {
        accessor.setBoundingRegions(analyzedDocument, boundingRegions);
    }

    static void setSpans(AnalyzedDocument analyzedDocument, List<DocumentSpan> spans) {
        accessor.setSpans(analyzedDocument, spans);
    }

    static void setFields(AnalyzedDocument analyzedDocument, Map<String, DocumentField> fields) {
        accessor.setFields(analyzedDocument, fields);
    }

    static void setConfidence(AnalyzedDocument analyzedDocument, float confidence) {
        accessor.setConfidence(analyzedDocument, confidence);
    }

    public static interface AnalyzedDocumentAccessor {
        public void setDocType(AnalyzedDocument var1, String var2);

        public void setBoundingRegions(AnalyzedDocument var1, List<BoundingRegion> var2);

        public void setSpans(AnalyzedDocument var1, List<DocumentSpan> var2);

        public void setFields(AnalyzedDocument var1, Map<String, DocumentField> var2);

        public void setConfidence(AnalyzedDocument var1, float var2);
    }
}

