/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis;

import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisServiceVersion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Constants;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Transforms;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Utility;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeDocumentOptions;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeResult;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DocumentAnalysisClientBuilder.class, isAsync=true)
public final class DocumentAnalysisAsyncClient {
    private final ClientLogger logger = new ClientLogger(DocumentAnalysisAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final DocumentAnalysisServiceVersion serviceVersion;

    DocumentAnalysisAsyncClient(FormRecognizerClientImpl service, DocumentAnalysisServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl) {
        return this.beginAnalyzeDocumentFromUrl(modelId, documentUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl, AnalyzeDocumentOptions analyzeDocumentOptions) {
        return this.beginAnalyzeDocumentFromUrl(documentUrl, modelId, analyzeDocumentOptions, Context.NONE);
    }

    PollerFlux<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String documentUrl, String modelId, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty((CharSequence)documentUrl)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'documentUrl' is required and cannot be null or empty"));
            }
            if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
            }
            AnalyzeDocumentOptions finalAnalyzeDocumentOptions = DocumentAnalysisAsyncClient.getAnalyzeDocumentOptions(analyzeDocumentOptions);
            return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, Utility.activationOperation(() -> this.service.analyzeDocumentWithResponseAsync(modelId, CoreUtils.isNullOrEmpty(finalAnalyzeDocumentOptions.getPages()) ? null : String.join((CharSequence)",", finalAnalyzeDocumentOptions.getPages()), finalAnalyzeDocumentOptions.getLocale() == null ? null : finalAnalyzeDocumentOptions.getLocale(), StringIndexType.UTF16CODE_UNIT, new AnalyzeDocumentRequest().setUrlSource(documentUrl), context).map(analyzeDocumentResponse -> Transforms.toDocumentOperationResult(((AnalyzeDocumentHeaders)analyzeDocumentResponse.getDeserializedHeaders()).getOperationLocation())), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeDocumentResultWithResponseAsync(modelId, (String)resultId, context)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeDocumentResultWithResponseAsync(modelId, (String)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toAnalyzeResultOperation(((AnalyzeResultOperation)modelSimpleResponse.getValue()).getAnalyzeResult())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document) {
        return this.beginAnalyzeDocument(modelId, document, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document, AnalyzeDocumentOptions analyzeDocumentOptions) {
        return this.beginAnalyzeDocument(modelId, document, analyzeDocumentOptions, Context.NONE);
    }

    PollerFlux<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        try {
            Objects.requireNonNull(document, "'document' is required and cannot be null.");
            if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
            }
            AnalyzeDocumentOptions finalAnalyzeDocumentOptions = DocumentAnalysisAsyncClient.getAnalyzeDocumentOptions(analyzeDocumentOptions);
            return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, Utility.activationOperation(() -> this.service.analyzeDocumentWithResponseAsync(modelId, null, CoreUtils.isNullOrEmpty(finalAnalyzeDocumentOptions.getPages()) ? null : String.join((CharSequence)",", finalAnalyzeDocumentOptions.getPages()), finalAnalyzeDocumentOptions.getLocale() == null ? null : finalAnalyzeDocumentOptions.getLocale(), StringIndexType.UTF16CODE_UNIT, document, document.getLength(), context).map(analyzeDocumentResponse -> Transforms.toDocumentOperationResult(((AnalyzeDocumentHeaders)analyzeDocumentResponse.getDeserializedHeaders()).getOperationLocation())), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeDocumentResultWithResponseAsync(modelId, (String)resultId, context)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeDocumentResultWithResponseAsync(modelId, (String)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toAnalyzeResultOperation(((AnalyzeResultOperation)modelSimpleResponse.getValue()).getAnalyzeResult())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<OperationResult>, Mono<PollResponse<OperationResult>>> pollingOperation(Function<String, Mono<Response<AnalyzeResultOperation>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                String resultId = ((OperationResult)operationResultPollResponse.getValue()).getOperationId();
                return ((Mono)pollingFunction.apply(resultId)).flatMap(modelResponse -> this.processAnalyzeModelResponse((Response<AnalyzeResultOperation>)modelResponse, (PollResponse<OperationResult>)operationResultPollResponse)).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<Response<AnalyzeResultOperation>>> fetchingOperation(Function<String, Mono<Response<AnalyzeResultOperation>>> fetchingFunction) {
        return pollingContext -> {
            try {
                String resultId = ((OperationResult)pollingContext.getLatestResponse().getValue()).getOperationId();
                return (Mono)fetchingFunction.apply(resultId);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<OperationResult>> processAnalyzeModelResponse(Response<AnalyzeResultOperation> analyzeResultOperationResponse, PollResponse<OperationResult> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((AnalyzeResultOperation)analyzeResultOperationResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)Transforms.mapResponseErrorToHttpResponseException(((AnalyzeResultOperation)analyzeResultOperationResponse.getValue()).getError())));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((AnalyzeResultOperation)analyzeResultOperationResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((OperationResult)operationResultPollResponse.getValue())));
    }

    private static AnalyzeDocumentOptions getAnalyzeDocumentOptions(AnalyzeDocumentOptions userProvidedOptions) {
        return userProvidedOptions == null ? new AnalyzeDocumentOptions() : userProvidedOptions;
    }
}

