/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis;

import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisAsyncClient;
import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeDocumentOptions;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeResult;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;

@ServiceClient(builder=DocumentAnalysisClientBuilder.class)
public final class DocumentAnalysisClient {
    private final DocumentAnalysisAsyncClient client;

    DocumentAnalysisClient(DocumentAnalysisAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl) {
        return this.beginAnalyzeDocumentFromUrl(modelId, documentUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        return this.client.beginAnalyzeDocumentFromUrl(documentUrl, modelId, analyzeDocumentOptions, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document) {
        return this.beginAnalyzeDocument(modelId, document, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        return this.client.beginAnalyzeDocument(modelId, document, analyzeDocumentOptions, context).getSyncPoller();
    }
}

