/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormReadingOrder;
import com.azure.ai.formrecognizer.models.FormRecognizerLanguage;
import java.time.Duration;
import java.util.List;

public final class RecognizeContentOptions {
    private FormContentType contentType;
    private Duration pollInterval = Utility.DEFAULT_POLL_INTERVAL;
    private FormRecognizerLanguage language;
    private List<String> pages;
    private FormReadingOrder readingOrder;

    public FormContentType getContentType() {
        return this.contentType;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public RecognizeContentOptions setContentType(FormContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public RecognizeContentOptions setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval == null ? Utility.DEFAULT_POLL_INTERVAL : pollInterval;
        return this;
    }

    public FormRecognizerLanguage getLanguage() {
        return this.language;
    }

    public RecognizeContentOptions setLanguage(FormRecognizerLanguage language) {
        this.language = language;
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public RecognizeContentOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }

    public FormReadingOrder getReadingOrder() {
        return this.readingOrder;
    }

    public RecognizeContentOptions setReadingOrder(FormReadingOrder readingOrder) {
        this.readingOrder = readingOrder;
        return this;
    }
}

