/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.FormLineHelper;
import com.azure.ai.formrecognizer.models.FieldBoundingBox;
import com.azure.ai.formrecognizer.models.FormElement;
import com.azure.ai.formrecognizer.models.FormWord;
import com.azure.ai.formrecognizer.models.TextAppearance;
import java.util.Collections;
import java.util.List;

public final class FormLine
extends FormElement {
    private final List<FormWord> words;
    private TextAppearance appearance;

    public FormLine(String text, FieldBoundingBox boundingBox, Integer pageNumber, List<FormWord> words) {
        super(text, boundingBox, pageNumber);
        this.words = words == null ? null : Collections.unmodifiableList(words);
    }

    public List<FormWord> getWords() {
        return this.words;
    }

    @Override
    public FieldBoundingBox getBoundingBox() {
        return super.getBoundingBox();
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    public int getPageNumber() {
        return super.getPageNumber();
    }

    private FormLine setAppearance(TextAppearance appearance) {
        this.appearance = appearance;
        return this;
    }

    public TextAppearance getAppearance() {
        return this.appearance;
    }

    static {
        FormLineHelper.setAccessor(new FormLineHelper.FormLineAccessor(){

            @Override
            public void setAppearance(FormLine formLine, TextAppearance textAppearance) {
                formLine.setAppearance(textAppearance);
            }
        });
    }
}

