// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Bounding polygon on a specific page of the input. */
@Fluent
public final class BoundingRegion {
    /*
     * 1-based page number of page containing the bounding region.
     */
    @JsonProperty(value = "pageNumber", required = true)
    private int pageNumber;

    /*
     * Bounding polygon on the page, or the entire page if not specified.
     */
    @JsonProperty(value = "polygon", required = true)
    private List<Float> polygon;

    /** Creates an instance of BoundingRegion class. */
    public BoundingRegion() {}

    /**
     * Get the pageNumber property: 1-based page number of page containing the bounding region.
     *
     * @return the pageNumber value.
     */
    public int getPageNumber() {
        return this.pageNumber;
    }

    /**
     * Set the pageNumber property: 1-based page number of page containing the bounding region.
     *
     * @param pageNumber the pageNumber value to set.
     * @return the BoundingRegion object itself.
     */
    public BoundingRegion setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    /**
     * Get the polygon property: Bounding polygon on the page, or the entire page if not specified.
     *
     * @return the polygon value.
     */
    public List<Float> getPolygon() {
        return this.polygon;
    }

    /**
     * Set the polygon property: Bounding polygon on the page, or the entire page if not specified.
     *
     * @param polygon the polygon value to set.
     * @return the BoundingRegion object itself.
     */
    public BoundingRegion setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }
}
