// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Contiguous region of the concatenated content property, specified as an offset and length. */
@Fluent
public final class DocumentSpan {
    /*
     * Zero-based index of the content represented by the span.
     */
    @JsonProperty(value = "offset", required = true)
    private int offset;

    /*
     * Number of characters in the content represented by the span.
     */
    @JsonProperty(value = "length", required = true)
    private int length;

    /** Creates an instance of DocumentSpan class. */
    public DocumentSpan() {}

    /**
     * Get the offset property: Zero-based index of the content represented by the span.
     *
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: Zero-based index of the content represented by the span.
     *
     * @param offset the offset value to set.
     * @return the DocumentSpan object itself.
     */
    public DocumentSpan setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: Number of characters in the content represented by the span.
     *
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: Number of characters in the content represented by the span.
     *
     * @param length the length value to set.
     * @return the DocumentSpan object itself.
     */
    public DocumentSpan setLength(int length) {
        this.length = length;
        return this;
    }
}
