// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An object representing observed text styles. */
@Fluent
public final class DocumentStyle {
    /*
     * Is content handwritten?
     */
    @JsonProperty(value = "isHandwritten")
    private Boolean isHandwritten;

    /*
     * Location of the text elements in the concatenated content the style applies to.
     */
    @JsonProperty(value = "spans", required = true)
    private List<DocumentSpan> spans;

    /*
     * Confidence of correctly identifying the style.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /** Creates an instance of DocumentStyle class. */
    public DocumentStyle() {}

    /**
     * Get the isHandwritten property: Is content handwritten?.
     *
     * @return the isHandwritten value.
     */
    public Boolean isHandwritten() {
        return this.isHandwritten;
    }

    /**
     * Set the isHandwritten property: Is content handwritten?.
     *
     * @param isHandwritten the isHandwritten value to set.
     * @return the DocumentStyle object itself.
     */
    public DocumentStyle setIsHandwritten(Boolean isHandwritten) {
        this.isHandwritten = isHandwritten;
        return this;
    }

    /**
     * Get the spans property: Location of the text elements in the concatenated content the style applies to.
     *
     * @return the spans value.
     */
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Set the spans property: Location of the text elements in the concatenated content the style applies to.
     *
     * @param spans the spans value to set.
     * @return the DocumentStyle object itself.
     */
    public DocumentStyle setSpans(List<DocumentSpan> spans) {
        this.spans = spans;
        return this;
    }

    /**
     * Get the confidence property: Confidence of correctly identifying the style.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence of correctly identifying the style.
     *
     * @param confidence the confidence value to set.
     * @return the DocumentStyle object itself.
     */
    public DocumentStyle setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }
}
