// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object representing the style of the text line. */
@Fluent
public final class Style {
    /*
     * The text line style name, including handwriting and other.
     */
    @JsonProperty(value = "name", required = true)
    private TextStyle name;

    /*
     * The confidence of text line style.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /**
     * Get the name property: The text line style name, including handwriting and other.
     *
     * @return the name value.
     */
    public TextStyle getName() {
        return this.name;
    }

    /**
     * Set the name property: The text line style name, including handwriting and other.
     *
     * @param name the name value to set.
     * @return the Style object itself.
     */
    public Style setName(TextStyle name) {
        this.name = name;
        return this;
    }

    /**
     * Get the confidence property: The confidence of text line style.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: The confidence of text line style.
     *
     * @param confidence the confidence value to set.
     * @return the Style object itself.
     */
    public Style setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }
}
