// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.training.models;

/**
 * Defines values for TrainingStatus.
 */
public enum TrainingStatus {
    /**
     * Enum value succeeded.
     */
    SUCCEEDED("succeeded"),

    /**
     * Enum value partiallySucceeded.
     */
    PARTIALLY_SUCCEEDED("partiallySucceeded"),

    /**
     * Enum value failed.
     */
    FAILED("failed");

    /**
     * The actual serialized value for a TrainingStatus instance.
     */
    private final String value;

    TrainingStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a TrainingStatus instance.
     *
     * @param value the serialized value to parse.
     *
     * @return the parsed TrainingStatus object, or null if unable to parse.
     */
    public static TrainingStatus fromString(String value) {
        TrainingStatus[] items = TrainingStatus.values();
        for (TrainingStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * The string representation of the enum value.
     *
     * @return the string representation of the enum value.
     */
    @Override
    public String toString() {
        return this.value;
    }
}
