/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.administration;

import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClient;
import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.administration.DocumentModelAdministrationClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BuildDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ComposeDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.CopyAuthorizationOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelBuildMode;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelCopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ResourceDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyDocumentModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Constants;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Transforms;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Utility;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentAnalysisAudience;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

@ServiceClient(builder=DocumentModelAdministrationClientBuilder.class)
public final class DocumentModelAdministrationClient {
    private static final ClientLogger LOGGER = new ClientLogger(DocumentModelAdministrationClient.class);
    private final FormRecognizerClientImpl service;
    private final DocumentAnalysisAudience audience;

    DocumentModelAdministrationClient(FormRecognizerClientImpl service, DocumentAnalysisAudience audience) {
        this.service = service;
        this.audience = audience;
    }

    public DocumentAnalysisClient getDocumentAnalysisClient() {
        return new DocumentAnalysisClientBuilder().endpoint(this.service.getEndpoint()).pipeline(this.service.getHttpPipeline()).audience(this.audience).buildClient();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginBuildDocumentModel(String blobContainerUrl, DocumentModelBuildMode buildMode) {
        return this.beginBuildDocumentModel(blobContainerUrl, buildMode, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginBuildDocumentModel(String blobContainerUrl, DocumentModelBuildMode buildMode, String prefix, BuildDocumentModelOptions buildDocumentModelOptions, Context context) {
        return this.beginBuildDocumentModelSync(blobContainerUrl, buildMode, prefix, buildDocumentModelOptions, context);
    }

    SyncPoller<OperationResult, DocumentModelDetails> beginBuildDocumentModelSync(String blobContainerUrl, DocumentModelBuildMode buildMode, String prefix, BuildDocumentModelOptions buildDocumentModelOptions, Context context) {
        BuildDocumentModelOptions finalBuildDocumentModelOptions = Utility.getBuildDocumentModelOptions(buildDocumentModelOptions);
        String modelId = finalBuildDocumentModelOptions.getModelId();
        if (modelId == null) {
            modelId = Utility.generateRandomModelID();
        }
        String finalModelId = modelId;
        Context finalContext = context = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.buildModelActivationOperation(blobContainerUrl, buildMode, finalModelId, prefix, finalBuildDocumentModelOptions, finalContext).apply((PollingContext<OperationResult>)cxt)), this.buildModelPollingOperation(finalContext), this.getCancellationIsNotSupported(), this.buildModelFetchingOperation(finalContext));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceDetails getResourceDetails() {
        return (ResourceDetails)this.getResourceDetailsWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceDetails> getResourceDetailsWithResponse(Context context) {
        try {
            Response<com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails> response = this.service.getResourceDetailsWithResponse(Utility.enableSyncRestProxy(Utility.getTracingContext(context)));
            return new SimpleResponse(response, (Object)Transforms.toAccountProperties((com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails)response.getValue()));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDocumentModel(String modelId) {
        this.deleteDocumentModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDocumentModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        try {
            return this.service.deleteDocumentModelWithResponse(modelId, Utility.enableSyncRestProxy(Utility.getTracingContext(context)));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelCopyAuthorization getCopyAuthorization() {
        return (DocumentModelCopyAuthorization)this.getCopyAuthorizationWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModelCopyAuthorization> getCopyAuthorizationWithResponse(CopyAuthorizationOptions copyAuthorizationOptions, Context context) {
        String modelId = (copyAuthorizationOptions = Utility.getCopyAuthorizationOptions(copyAuthorizationOptions)).getModelId();
        modelId = modelId == null ? Utility.generateRandomModelID() : modelId;
        AuthorizeCopyRequest authorizeCopyRequest = Transforms.getAuthorizeCopyRequest(copyAuthorizationOptions, modelId);
        try {
            Response<CopyAuthorization> response = this.service.authorizeCopyDocumentModelWithResponse(authorizeCopyRequest, Utility.enableSyncRestProxy(Utility.getTracingContext(context)));
            return new SimpleResponse(response, (Object)Transforms.toCopyAuthorization((CopyAuthorization)response.getValue()));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds) {
        return this.beginComposeDocumentModel(componentModelIds, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds, ComposeDocumentModelOptions composeDocumentModelOptions, Context context) {
        return this.beginComposeDocumentModelSync(componentModelIds, composeDocumentModelOptions, context);
    }

    SyncPoller<OperationResult, DocumentModelDetails> beginComposeDocumentModelSync(List<String> componentModelIds, ComposeDocumentModelOptions composeDocumentModelOptions, Context context) {
        if (CoreUtils.isNullOrEmpty(componentModelIds)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'componentModelIds' cannot be null or empty"));
        }
        String modelId = (composeDocumentModelOptions = Utility.getComposeModelOptions(composeDocumentModelOptions)).getModelId();
        modelId = modelId == null ? Utility.generateRandomModelID() : modelId;
        ComposeDocumentModelRequest composeRequest = Transforms.getComposeDocumentModelRequest(componentModelIds, composeDocumentModelOptions, modelId);
        Context finalContext = context = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.composeModelActivationOperation(composeRequest, finalContext).apply((PollingContext<OperationResult>)cxt)), this.buildModelPollingOperation(finalContext), this.getCancellationIsNotSupported(), this.buildModelFetchingOperation(finalContext));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginCopyDocumentModelTo(String sourceModelId, DocumentModelCopyAuthorization target) {
        return this.beginCopyDocumentModelTo(sourceModelId, target, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, DocumentModelDetails> beginCopyDocumentModelTo(String sourceModelId, DocumentModelCopyAuthorization target, Context context) {
        return this.beginCopyDocumentModelToSync(sourceModelId, target, context);
    }

    SyncPoller<OperationResult, DocumentModelDetails> beginCopyDocumentModelToSync(String sourceModelId, DocumentModelCopyAuthorization target, Context context) {
        Context finalContext = context = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.getCopyActivationOperation(sourceModelId, target, finalContext).apply((PollingContext<OperationResult>)cxt)), this.buildModelPollingOperation(finalContext), this.getCancellationIsNotSupported(), this.buildModelFetchingOperation(finalContext));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listDocumentModels() {
        return this.listDocumentModels(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listDocumentModels(Context context) {
        return this.listDocumentModelsSync(context);
    }

    PagedIterable<DocumentModelSummary> listDocumentModelsSync(Context context) {
        Context finalContext = context = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return new PagedIterable(() -> this.listFirstPageModelInfo(finalContext), continuationToken -> this.listNextPageModelInfo((String)continuationToken, finalContext));
    }

    private PagedResponse<DocumentModelSummary> listFirstPageModelInfo(Context context) {
        try {
            PagedResponse<com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary> res = this.service.getDocumentModelsSinglePage(context);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toDocumentModelInfo(res.getValue()), (String)res.getContinuationToken(), null);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    private PagedResponse<DocumentModelSummary> listNextPageModelInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return null;
        }
        try {
            PagedResponse<com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary> res = this.service.getDocumentModelsNextSinglePage(nextPageLink, context);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toDocumentModelInfo(res.getValue()), (String)res.getContinuationToken(), null);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelDetails getDocumentModel(String modelId) {
        return (DocumentModelDetails)this.getDocumentModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModelDetails> getDocumentModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        try {
            Response<com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails> response = this.service.getDocumentModelWithResponse(modelId, Utility.enableSyncRestProxy(Utility.getTracingContext(context)));
            return new SimpleResponse(response, (Object)Transforms.toDocumentModelDetails((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails)response.getValue()));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationDetails getOperation(String operationId) {
        return (OperationDetails)this.getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationDetails> getOperationWithResponse(String operationId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)operationId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'operationId' is required and cannot be null or empty"));
        }
        try {
            Response<com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails> response = this.service.getOperationWithResponse(operationId, Utility.enableSyncRestProxy(Utility.getTracingContext(context)));
            return new SimpleResponse(response, (Object)Transforms.toOperationDetails((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)response.getValue()));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> listOperations() {
        return this.listOperations(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> listOperations(Context context) {
        return this.listOperationsSync(context);
    }

    PagedIterable<OperationSummary> listOperationsSync(Context context) {
        Context finalContext = context = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return new PagedIterable(() -> this.listFirstPageOperationInfo(finalContext), continuationToken -> this.listNextPageOperationInfo((String)continuationToken, finalContext));
    }

    private PagedResponse<OperationSummary> listFirstPageOperationInfo(Context context) {
        try {
            PagedResponse<com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationSummary> res = this.service.getOperationsSinglePage(context);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toOperationSummary(res.getValue()), (String)res.getContinuationToken(), null);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    private PagedResponse<OperationSummary> listNextPageOperationInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return null;
        }
        try {
            PagedResponse<com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationSummary> res = this.service.getOperationsNextSinglePage(nextPageLink, context);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toOperationSummary(res.getValue()), (String)res.getContinuationToken(), null);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    private Function<PollingContext<OperationResult>, OperationResult> buildModelActivationOperation(String blobContainerUrl, DocumentModelBuildMode buildMode, String modelId, String prefix, BuildDocumentModelOptions buildDocumentModelOptions, Context context) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(blobContainerUrl, "'blobContainerUrl' cannot be null.");
                BuildDocumentModelRequest buildDocumentModelRequest = Transforms.getBuildDocumentModelRequest(blobContainerUrl, buildMode, modelId, prefix, buildDocumentModelOptions);
                ResponseBase<BuildDocumentModelHeaders, Void> response = this.service.buildDocumentModelWithResponse(buildDocumentModelRequest, context);
                return Transforms.toDocumentOperationResult(((BuildDocumentModelHeaders)response.getDeserializedHeaders()).getOperationLocation());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }

    private Function<PollingContext<OperationResult>, PollResponse<OperationResult>> buildModelPollingOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                String modelId = ((OperationResult)operationResultPollResponse.getValue()).getOperationId();
                Response<com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails> modelSimpleResponse = this.service.getOperationWithResponse(modelId, context);
                return this.processBuildingModelResponse((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)modelSimpleResponse.getValue(), (PollResponse<OperationResult>)operationResultPollResponse);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }

    private PollResponse<OperationResult> processBuildingModelResponse(com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails getOperationResponse, PollResponse<OperationResult> trainingModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (getOperationResponse.getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.mapResponseErrorToHttpResponseException(getOperationResponse.getError())));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)getOperationResponse.getStatus().toString(), (boolean)true);
            }
        }
        return new PollResponse(status, (Object)((OperationResult)trainingModelOperationResponse.getValue()));
    }

    private BiFunction<PollingContext<OperationResult>, PollResponse<OperationResult>, OperationResult> getCancellationIsNotSupported() {
        return (pollingContext, activationResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        };
    }

    private Function<PollingContext<OperationResult>, DocumentModelDetails> buildModelFetchingOperation(Context context) {
        return pollingContext -> {
            try {
                String modelId = ((OperationResult)pollingContext.getLatestResponse().getValue()).getOperationId();
                return Transforms.toDocumentModelFromOperationId((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)this.service.getOperationWithResponse(modelId, context).getValue());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }

    private Function<PollingContext<OperationResult>, OperationResult> composeModelActivationOperation(ComposeDocumentModelRequest composeRequest, Context context) {
        return pollingContext -> {
            try {
                ResponseBase<ComposeDocumentModelHeaders, Void> response = this.service.composeDocumentModelWithResponse(composeRequest, context);
                return Transforms.toDocumentOperationResult(((ComposeDocumentModelHeaders)response.getDeserializedHeaders()).getOperationLocation());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }

    private Function<PollingContext<OperationResult>, OperationResult> getCopyActivationOperation(String modelId, DocumentModelCopyAuthorization target, Context context) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(modelId, "'modelId' cannot be null.");
                Objects.requireNonNull(target, "'target' cannot be null.");
                CopyAuthorization copyRequest = Transforms.getInnerCopyAuthorization(target);
                ResponseBase<CopyDocumentModelToHeaders, Void> response = this.service.copyDocumentModelToWithResponse(modelId, copyRequest, context);
                return Transforms.toDocumentOperationResult(((CopyDocumentModelToHeaders)response.getDeserializedHeaders()).getOperationLocation());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }
}

