/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.RecognizedFormHelper;
import com.azure.ai.formrecognizer.models.FormField;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormPageRange;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RecognizedForm {
    private final Map<String, FormField> fields;
    private final String formType;
    private final FormPageRange pageRange;
    private final List<FormPage> pages;
    private Float formTypeConfidence;
    private String modelId;

    public RecognizedForm(Map<String, FormField> fields, String formType, FormPageRange pageRange, List<FormPage> pages) {
        this.fields = fields == null ? null : Collections.unmodifiableMap(fields);
        this.formType = formType;
        this.pageRange = pageRange;
        this.pages = pages == null ? null : Collections.unmodifiableList(pages);
    }

    public Map<String, FormField> getFields() {
        return this.fields;
    }

    public String getFormType() {
        return this.formType;
    }

    public FormPageRange getPageRange() {
        return this.pageRange;
    }

    public List<FormPage> getPages() {
        return this.pages;
    }

    public Float getFormTypeConfidence() {
        return this.formTypeConfidence;
    }

    public String getModelId() {
        return this.modelId;
    }

    private void setFormTypeConfidence(Float formTypeConfidence) {
        this.formTypeConfidence = formTypeConfidence;
    }

    private void setModelId(String modelId) {
        this.modelId = modelId;
    }

    static {
        RecognizedFormHelper.setAccessor(new RecognizedFormHelper.RecognizedFormAccessor(){

            @Override
            public void setFormTypeConfidence(RecognizedForm form, Float formTypeConfidence) {
                form.setFormTypeConfidence(formTypeConfidence);
            }

            @Override
            public void setModelId(RecognizedForm form, String modelId) {
                form.setModelId(modelId);
            }
        });
    }
}

