// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Request body to build a new custom document model. */
@Fluent
public final class BuildDocumentModelRequest {
    /*
     * Unique document model name.
     */
    @JsonProperty(value = "modelId", required = true)
    private String modelId;

    /*
     * Document model description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Custom document model build mode.
     */
    @JsonProperty(value = "buildMode", required = true)
    private DocumentBuildMode buildMode;

    /*
     * Azure Blob Storage location containing the training data.
     */
    @JsonProperty(value = "azureBlobSource")
    private AzureBlobContentSource azureBlobSource;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /** Creates an instance of BuildDocumentModelRequest class. */
    public BuildDocumentModelRequest() {}

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Set the modelId property: Unique document model name.
     *
     * @param modelId the modelId value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    public BuildDocumentModelRequest setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     *
     * @param description the description value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    public BuildDocumentModelRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     *
     * @return the buildMode value.
     */
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Set the buildMode property: Custom document model build mode.
     *
     * @param buildMode the buildMode value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    public BuildDocumentModelRequest setBuildMode(DocumentBuildMode buildMode) {
        this.buildMode = buildMode;
        return this;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data.
     *
     * @return the azureBlobSource value.
     */
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Set the azureBlobSource property: Azure Blob Storage location containing the training data.
     *
     * @param azureBlobSource the azureBlobSource value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    public BuildDocumentModelRequest setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     *
     * @param tags the tags value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    public BuildDocumentModelRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }
}
