// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List Operations response object. */
@Fluent
public final class GetOperationsResponse {
    /*
     * List of operations.
     */
    @JsonProperty(value = "value", required = true)
    private List<OperationSummary> value;

    /*
     * Link to the next page of operations.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of GetOperationsResponse class. */
    public GetOperationsResponse() {}

    /**
     * Get the value property: List of operations.
     *
     * @return the value value.
     */
    public List<OperationSummary> getValue() {
        return this.value;
    }

    /**
     * Set the value property: List of operations.
     *
     * @param value the value value to set.
     * @return the GetOperationsResponse object itself.
     */
    public GetOperationsResponse setValue(List<OperationSummary> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next page of operations.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next page of operations.
     *
     * @param nextLink the nextLink value to set.
     * @return the GetOperationsResponse object itself.
     */
    public GetOperationsResponse setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }
}
