/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyDocumentModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentModelsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetOperationsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FormRecognizerClientImpl {
    private final FormRecognizerClientService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    FormRecognizerClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    FormRecognizerClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    FormRecognizerClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service = (FormRecognizerClientService)RestProxy.create(FormRecognizerClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), analyzeRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocumentSync(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, analyzeRequest), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, analyzeRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, analyzeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, analyzeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocument(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        return this.service.analyzeDocumentSync(this.getEndpoint(), modelId, pages, locale, stringIndexType, this.getApiVersion(), contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, BinaryData analyzeRequest, Long contentLength, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResultWithResponseAsync(String modelId, String resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeDocumentResult(this.getEndpoint(), modelId, resultId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResultWithResponseAsync(String modelId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeDocumentResult(this.getEndpoint(), modelId, resultId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeDocumentResultAsync(String modelId, String resultId) {
        return this.getAnalyzeDocumentResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeResultOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeDocumentResultAsync(String modelId, String resultId, Context context) {
        return this.getAnalyzeDocumentResultWithResponseAsync(modelId, resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeResultOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getAnalyzeDocumentResultWithResponse(String modelId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeDocumentResultSync(this.getEndpoint(), modelId, resultId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeResultOperation getAnalyzeDocumentResult(String modelId, String resultId) {
        return (AnalyzeResultOperation)this.getAnalyzeDocumentResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BuildDocumentModelHeaders, Void>> buildDocumentModelWithResponseAsync(BuildDocumentModelRequest buildRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.buildDocumentModel(this.getEndpoint(), this.getApiVersion(), buildRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<BuildDocumentModelHeaders, Void>> buildDocumentModelWithResponseAsync(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildDocumentModel(this.getEndpoint(), this.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<BuildDocumentModelHeaders, Void> buildDocumentModelWithResponse(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildDocumentModelSync(this.getEndpoint(), this.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModelAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponseAsync(buildRequest), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModelAsync(BuildDocumentModelRequest buildRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponseAsync(buildRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponse(buildRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BuildDocumentModelRequest buildRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildDocumentModelWithResponse(buildRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ComposeDocumentModelHeaders, Void>> composeDocumentModelWithResponseAsync(ComposeDocumentModelRequest composeRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.composeDocumentModel(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<ComposeDocumentModelHeaders, Void>> composeDocumentModelWithResponseAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeDocumentModel(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<ComposeDocumentModelHeaders, Void> composeDocumentModelWithResponse(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeDocumentModelSync(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeDocumentModelAsync(ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeDocumentModelWithResponseAsync(composeRequest), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeDocumentModelAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeDocumentModelWithResponseAsync(composeRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeDocumentModel(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeDocumentModelWithResponse(composeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeDocumentModel(ComposeDocumentModelRequest composeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeDocumentModelWithResponse(composeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModelWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.authorizeCopyDocumentModel(this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModelWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        String accept = "application/json";
        return this.service.authorizeCopyDocumentModel(this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeCopyDocumentModelAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return this.authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest).flatMap(res -> Mono.justOrEmpty((Object)((CopyAuthorization)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeCopyDocumentModelAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return this.authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((CopyAuthorization)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyAuthorization> authorizeCopyDocumentModelWithResponse(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        String accept = "application/json";
        return this.service.authorizeCopyDocumentModelSync(this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization authorizeCopyDocumentModel(AuthorizeCopyRequest authorizeCopyRequest) {
        return (CopyAuthorization)this.authorizeCopyDocumentModelWithResponse(authorizeCopyRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CopyDocumentModelToHeaders, Void>> copyDocumentModelToWithResponseAsync(String modelId, CopyAuthorization copyToRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.copyDocumentModelTo(this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CopyDocumentModelToHeaders, Void>> copyDocumentModelToWithResponseAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyDocumentModelTo(this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CopyDocumentModelToHeaders, Void> copyDocumentModelToWithResponse(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyDocumentModelToSync(this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyDocumentModelToAsync(String modelId, CopyAuthorization copyToRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyDocumentModelToAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest, context), (PollingStrategy)new DefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyDocumentModelTo(String modelId, CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyDocumentModelToWithResponse(modelId, copyToRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyDocumentModelTo(String modelId, CopyAuthorization copyToRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyDocumentModelToWithResponse(modelId, copyToRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(this.getHttpPipeline(), "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperations(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.getOperations(this.getEndpoint(), this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> getOperationsAsync() {
        return new PagedFlux(() -> this.getOperationsSinglePageAsync(), nextLink -> this.getOperationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> getOperationsAsync(Context context) {
        return new PagedFlux(() -> this.getOperationsSinglePageAsync(context), nextLink -> this.getOperationsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsSinglePage() {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.getOperationsSync(this.getEndpoint(), this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsSinglePage(Context context) {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.getOperationsSync(this.getEndpoint(), this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> getOperations() {
        return new PagedIterable(() -> this.getOperationsSinglePage(Context.NONE), nextLink -> this.getOperationsNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> getOperations(Context context) {
        return new PagedIterable(() -> this.getOperationsSinglePage(context), nextLink -> this.getOperationsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponseAsync(String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperation(this.getEndpoint(), operationId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperation(this.getEndpoint(), operationId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationAsync(String operationId) {
        return this.getOperationWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty((Object)((OperationDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationAsync(String operationId, Context context) {
        return this.getOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty((Object)((OperationDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationDetails> getOperationWithResponse(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperationSync(this.getEndpoint(), operationId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationDetails getOperation(String operationId) {
        return (OperationDetails)this.getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDocumentModels(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.getDocumentModels(this.getEndpoint(), this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> getDocumentModelsAsync() {
        return new PagedFlux(() -> this.getDocumentModelsSinglePageAsync(), nextLink -> this.getDocumentModelsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> getDocumentModelsAsync(Context context) {
        return new PagedFlux(() -> this.getDocumentModelsSinglePageAsync(context), nextLink -> this.getDocumentModelsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsSinglePage() {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.getDocumentModelsSync(this.getEndpoint(), this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsSinglePage(Context context) {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.getDocumentModelsSync(this.getEndpoint(), this.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> getDocumentModels() {
        return new PagedIterable(() -> this.getDocumentModelsSinglePage(Context.NONE), nextLink -> this.getDocumentModelsNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> getDocumentModels(Context context) {
        return new PagedIterable(() -> this.getDocumentModelsSinglePage(context), nextLink -> this.getDocumentModelsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getDocumentModelWithResponseAsync(String modelId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getDocumentModelWithResponseAsync(String modelId, Context context) {
        String accept = "application/json";
        return this.service.getDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getDocumentModelAsync(String modelId) {
        return this.getDocumentModelWithResponseAsync(modelId).flatMap(res -> Mono.justOrEmpty((Object)((DocumentModelDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getDocumentModelAsync(String modelId, Context context) {
        return this.getDocumentModelWithResponseAsync(modelId, context).flatMap(res -> Mono.justOrEmpty((Object)((DocumentModelDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModelDetails> getDocumentModelWithResponse(String modelId, Context context) {
        String accept = "application/json";
        return this.service.getDocumentModelSync(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelDetails getDocumentModel(String modelId) {
        return (DocumentModelDetails)this.getDocumentModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDocumentModelWithResponseAsync(String modelId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDocumentModelWithResponseAsync(String modelId, Context context) {
        String accept = "application/json";
        return this.service.deleteDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDocumentModelAsync(String modelId) {
        return this.deleteDocumentModelWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDocumentModelAsync(String modelId, Context context) {
        return this.deleteDocumentModelWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDocumentModelWithResponse(String modelId, Context context) {
        String accept = "application/json";
        return this.service.deleteDocumentModelSync(this.getEndpoint(), modelId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDocumentModel(String modelId) {
        this.deleteDocumentModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceDetailsWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceDetails(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceDetailsWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.getResourceDetails(this.getEndpoint(), this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceDetailsAsync() {
        return this.getResourceDetailsWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((ResourceDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceDetailsAsync(Context context) {
        return this.getResourceDetailsWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((ResourceDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceDetails> getResourceDetailsWithResponse(Context context) {
        String accept = "application/json";
        return this.service.getResourceDetailsSync(this.getEndpoint(), this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceDetails getResourceDetails() {
        return (ResourceDetails)this.getResourceDetailsWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperationsNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getOperationsNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.getOperationsNextSync(nextLink, this.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.getOperationsNextSync(nextLink, this.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDocumentModelsNext(nextLink, this.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getDocumentModelsNext(nextLink, this.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.getDocumentModelsNextSync(nextLink, this.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.getDocumentModelsNextSync(nextLink, this.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @Host(value="{endpoint}/formrecognizer")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface FormRecognizerClientService {
        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AnalyzeDocumentRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AnalyzeDocumentRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Content-Type") ContentType var7, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Content-Type") ContentType var7, @BodyParam(value="application/octet-stream") BinaryData var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Content-Type") ContentType var7, @BodyParam(value="application/octet-stream") BinaryData var8, @HeaderParam(value="Content-Length") Long var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResult(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<AnalyzeResultOperation> getAnalyzeDocumentResultSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<BuildDocumentModelHeaders, Void>> buildDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<BuildDocumentModelHeaders, Void> buildDocumentModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<ComposeDocumentModelHeaders, Void>> composeDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<ComposeDocumentModelHeaders, Void> composeDocumentModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AuthorizeCopyRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<CopyAuthorization> authorizeCopyDocumentModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AuthorizeCopyRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CopyDocumentModelToHeaders, Void>> copyDocumentModelTo(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<CopyDocumentModelToHeaders, Void> copyDocumentModelToSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationsResponse>> getOperations(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetOperationsResponse> getOperationsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<OperationDetails>> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<OperationDetails> getOperationSync(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetDocumentModelsResponse>> getDocumentModels(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetDocumentModelsResponse> getDocumentModelsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<DocumentModelDetails>> getDocumentModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<DocumentModelDetails> getDocumentModelSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteDocumentModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteDocumentModelSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ResourceDetails>> getResourceDetails(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ResourceDetails> getResourceDetailsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationsResponse>> getOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetOperationsResponse> getOperationsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetDocumentModelsResponse>> getDocumentModelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetDocumentModelsResponse> getDocumentModelsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

