/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeBusinessCardAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeIdDocumentAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeInvoiceAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeLayoutAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeReceiptAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeWithCustomModelResponse;
import com.azure.ai.formrecognizer.implementation.models.ComposeCustomModelsAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.ComposeRequest;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyCustomModelResponse;
import com.azure.ai.formrecognizer.implementation.models.CopyOperationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyRequest;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.GenerateModelCopyAuthorizationResponse;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.implementation.models.TrainCustomModelAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FormRecognizerClientImpl {
    private final FormRecognizerClientService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    FormRecognizerClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    FormRecognizerClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    FormRecognizerClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service = (FormRecognizerClientService)RestProxy.create(FormRecognizerClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsyncWithResponseAsync(TrainRequest trainRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.trainCustomModelAsync(this.getEndpoint(), this.getApiVersion(), trainRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsyncWithResponseAsync(TrainRequest trainRequest, Context context) {
        String accept = "application/json";
        return this.service.trainCustomModelAsync(this.getEndpoint(), this.getApiVersion(), trainRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> trainCustomModelAsyncAsync(TrainRequest trainRequest) {
        return this.trainCustomModelAsyncWithResponseAsync(trainRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> trainCustomModelAsyncAsync(TrainRequest trainRequest, Context context) {
        return this.trainCustomModelAsyncWithResponseAsync(trainRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void trainCustomModelAsync(TrainRequest trainRequest) {
        this.trainCustomModelAsyncAsync(trainRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TrainCustomModelAsyncResponse trainCustomModelAsyncWithResponse(TrainRequest trainRequest, Context context) {
        return (TrainCustomModelAsyncResponse)((Object)this.trainCustomModelAsyncWithResponseAsync(trainRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Model>> getCustomModelWithResponseAsync(UUID modelId, Boolean includeKeys) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeKeys, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Model>> getCustomModelWithResponseAsync(UUID modelId, Boolean includeKeys, Context context) {
        String accept = "application/json";
        return this.service.getCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeKeys, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Model> getCustomModelAsync(UUID modelId, Boolean includeKeys) {
        return this.getCustomModelWithResponseAsync(modelId, includeKeys).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Model)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Model> getCustomModelAsync(UUID modelId, Boolean includeKeys, Context context) {
        return this.getCustomModelWithResponseAsync(modelId, includeKeys, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Model)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Model getCustomModel(UUID modelId, Boolean includeKeys) {
        return (Model)this.getCustomModelAsync(modelId, includeKeys).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Model> getCustomModelWithResponse(UUID modelId, Boolean includeKeys, Context context) {
        return (Response)this.getCustomModelWithResponseAsync(modelId, includeKeys, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCustomModelWithResponseAsync(UUID modelId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCustomModelWithResponseAsync(UUID modelId, Context context) {
        String accept = "application/json";
        return this.service.deleteCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCustomModelAsync(UUID modelId) {
        return this.deleteCustomModelWithResponseAsync(modelId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteCustomModelAsync(UUID modelId, Context context) {
        return this.deleteCustomModelWithResponseAsync(modelId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteCustomModel(UUID modelId) {
        this.deleteCustomModelAsync(modelId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteCustomModelWithResponse(UUID modelId, Context context) {
        return (Response)this.deleteCustomModelWithResponseAsync(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeWithCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeWithCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeWithCustomModelWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeWithCustomModelWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeWithCustomModel(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeWithCustomModelAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeWithCustomModelResponse analyzeWithCustomModelWithResponse(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (AnalyzeWithCustomModelResponse)((Object)this.analyzeWithCustomModelWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeWithCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeTextDetails, pagesConverted, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeWithCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, includeTextDetails, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return this.analyzeWithCustomModelWithResponseAsync(modelId, includeTextDetails, pages, fileStream).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeWithCustomModelAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeWithCustomModelWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeWithCustomModel(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        this.analyzeWithCustomModelAsync(modelId, includeTextDetails, pages, fileStream).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeWithCustomModelResponse analyzeWithCustomModelWithResponse(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return (AnalyzeWithCustomModelResponse)((Object)this.analyzeWithCustomModelWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeFormResultWithResponseAsync(UUID modelId, UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeFormResult(this.getEndpoint(), this.getApiVersion(), modelId, resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeFormResultWithResponseAsync(UUID modelId, UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeFormResult(this.getEndpoint(), this.getApiVersion(), modelId, resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeFormResultAsync(UUID modelId, UUID resultId) {
        return this.getAnalyzeFormResultWithResponseAsync(modelId, resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeFormResultAsync(UUID modelId, UUID resultId, Context context) {
        return this.getAnalyzeFormResultWithResponseAsync(modelId, resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeFormResult(UUID modelId, UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeFormResultAsync(modelId, resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeFormResultWithResponse(UUID modelId, UUID resultId, Context context) {
        return (Response)this.getAnalyzeFormResultWithResponseAsync(modelId, resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyCustomModelResponse> copyCustomModelWithResponseAsync(UUID modelId, CopyRequest copyRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.copyCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, copyRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyCustomModelResponse> copyCustomModelWithResponseAsync(UUID modelId, CopyRequest copyRequest, Context context) {
        String accept = "application/json";
        return this.service.copyCustomModel(this.getEndpoint(), this.getApiVersion(), modelId, copyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> copyCustomModelAsync(UUID modelId, CopyRequest copyRequest) {
        return this.copyCustomModelWithResponseAsync(modelId, copyRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> copyCustomModelAsync(UUID modelId, CopyRequest copyRequest, Context context) {
        return this.copyCustomModelWithResponseAsync(modelId, copyRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void copyCustomModel(UUID modelId, CopyRequest copyRequest) {
        this.copyCustomModelAsync(modelId, copyRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyCustomModelResponse copyCustomModelWithResponse(UUID modelId, CopyRequest copyRequest, Context context) {
        return (CopyCustomModelResponse)((Object)this.copyCustomModelWithResponseAsync(modelId, copyRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCustomModelCopyResultWithResponseAsync(UUID modelId, UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCustomModelCopyResult(this.getEndpoint(), this.getApiVersion(), modelId, resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCustomModelCopyResultWithResponseAsync(UUID modelId, UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getCustomModelCopyResult(this.getEndpoint(), this.getApiVersion(), modelId, resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCustomModelCopyResultAsync(UUID modelId, UUID resultId) {
        return this.getCustomModelCopyResultWithResponseAsync(modelId, resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CopyOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCustomModelCopyResultAsync(UUID modelId, UUID resultId, Context context) {
        return this.getCustomModelCopyResultWithResponseAsync(modelId, resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CopyOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyOperationResult getCustomModelCopyResult(UUID modelId, UUID resultId) {
        return (CopyOperationResult)this.getCustomModelCopyResultAsync(modelId, resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyOperationResult> getCustomModelCopyResultWithResponse(UUID modelId, UUID resultId, Context context) {
        return (Response)this.getCustomModelCopyResultWithResponseAsync(modelId, resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenerateModelCopyAuthorizationResponse> generateModelCopyAuthorizationWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateModelCopyAuthorization(this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GenerateModelCopyAuthorizationResponse> generateModelCopyAuthorizationWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.generateModelCopyAuthorization(this.getEndpoint(), this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> generateModelCopyAuthorizationAsync() {
        return this.generateModelCopyAuthorizationWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> generateModelCopyAuthorizationAsync(Context context) {
        return this.generateModelCopyAuthorizationWithResponseAsync(context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorizationResult generateModelCopyAuthorization() {
        return (CopyAuthorizationResult)this.generateModelCopyAuthorizationAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GenerateModelCopyAuthorizationResponse generateModelCopyAuthorizationWithResponse(Context context) {
        return (GenerateModelCopyAuthorizationResponse)((Object)this.generateModelCopyAuthorizationWithResponseAsync(context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ComposeCustomModelsAsyncResponse> composeCustomModelsAsyncWithResponseAsync(ComposeRequest composeRequest) {
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.composeCustomModelsAsync(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json, text/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ComposeCustomModelsAsyncResponse> composeCustomModelsAsyncWithResponseAsync(ComposeRequest composeRequest, Context context) {
        String accept = "application/json, text/json";
        return this.service.composeCustomModelsAsync(this.getEndpoint(), this.getApiVersion(), composeRequest, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> composeCustomModelsAsyncAsync(ComposeRequest composeRequest) {
        return this.composeCustomModelsAsyncWithResponseAsync(composeRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> composeCustomModelsAsyncAsync(ComposeRequest composeRequest, Context context) {
        return this.composeCustomModelsAsyncWithResponseAsync(composeRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void composeCustomModelsAsync(ComposeRequest composeRequest) {
        this.composeCustomModelsAsyncAsync(composeRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ComposeCustomModelsAsyncResponse composeCustomModelsAsyncWithResponse(ComposeRequest composeRequest, Context context) {
        return (ComposeCustomModelsAsyncResponse)((Object)this.composeCustomModelsAsyncWithResponseAsync(composeRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeBusinessCardAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeBusinessCardAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeBusinessCardAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeBusinessCardAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeBusinessCardAsyncAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeBusinessCardAsyncResponse analyzeBusinessCardAsyncWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (AnalyzeBusinessCardAsyncResponse)((Object)this.analyzeBusinessCardAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeBusinessCardAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsyncWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeBusinessCardAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return this.analyzeBusinessCardAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsyncAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeBusinessCardAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeBusinessCardAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        this.analyzeBusinessCardAsyncAsync(includeTextDetails, locale, pages, fileStream).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeBusinessCardAsyncResponse analyzeBusinessCardAsyncWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (AnalyzeBusinessCardAsyncResponse)((Object)this.analyzeBusinessCardAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeBusinessCardResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeBusinessCardResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId) {
        return this.getAnalyzeBusinessCardResultWithResponseAsync(resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeBusinessCardResultWithResponseAsync(resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeBusinessCardResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeBusinessCardResultAsync(resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeBusinessCardResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeBusinessCardResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeInvoiceAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeInvoiceAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeInvoiceAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeInvoiceAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeInvoiceAsyncAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeInvoiceAsyncResponse analyzeInvoiceAsyncWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (AnalyzeInvoiceAsyncResponse)((Object)this.analyzeInvoiceAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeInvoiceAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsyncWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeInvoiceAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return this.analyzeInvoiceAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsyncAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeInvoiceAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeInvoiceAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        this.analyzeInvoiceAsyncAsync(includeTextDetails, locale, pages, fileStream).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeInvoiceAsyncResponse analyzeInvoiceAsyncWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (AnalyzeInvoiceAsyncResponse)((Object)this.analyzeInvoiceAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeInvoiceResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeInvoiceResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId) {
        return this.getAnalyzeInvoiceResultWithResponseAsync(resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeInvoiceResultWithResponseAsync(resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeInvoiceResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeInvoiceResultAsync(resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeInvoiceResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeInvoiceResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeIdDocumentAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeIdDocumentAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeIdDocumentAsyncWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeIdDocumentAsyncWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeIdDocumentAsyncAsync(contentType, includeTextDetails, pages, fileStream, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeIdDocumentAsyncResponse analyzeIdDocumentAsyncWithResponse(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (AnalyzeIdDocumentAsyncResponse)((Object)this.analyzeIdDocumentAsyncWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeIdDocumentAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, pagesConverted, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsyncWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeIdDocumentAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return this.analyzeIdDocumentAsyncWithResponseAsync(includeTextDetails, pages, fileStream).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsyncAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeIdDocumentAsyncWithResponseAsync(includeTextDetails, pages, fileStream, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeIdDocumentAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        this.analyzeIdDocumentAsyncAsync(includeTextDetails, pages, fileStream).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeIdDocumentAsyncResponse analyzeIdDocumentAsyncWithResponse(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return (AnalyzeIdDocumentAsyncResponse)((Object)this.analyzeIdDocumentAsyncWithResponseAsync(includeTextDetails, pages, fileStream, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeIdDocumentResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeIdDocumentResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId) {
        return this.getAnalyzeIdDocumentResultWithResponseAsync(resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeIdDocumentResultWithResponseAsync(resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeIdDocumentResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeIdDocumentResultAsync(resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeIdDocumentResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeIdDocumentResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeReceiptAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeReceiptAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeReceiptAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeReceiptAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeReceiptAsyncAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeReceiptAsyncResponse analyzeReceiptAsyncWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (AnalyzeReceiptAsyncResponse)((Object)this.analyzeReceiptAsyncWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeReceiptAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeReceiptAsync(this.getEndpoint(), this.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return this.analyzeReceiptAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsyncAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeReceiptAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeReceiptAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        this.analyzeReceiptAsyncAsync(includeTextDetails, locale, pages, fileStream).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeReceiptAsyncResponse analyzeReceiptAsyncWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (AnalyzeReceiptAsyncResponse)((Object)this.analyzeReceiptAsyncWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeReceiptResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeReceiptResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId) {
        return this.getAnalyzeReceiptResultWithResponseAsync(resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeReceiptResultWithResponseAsync(resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeReceiptResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeReceiptResultAsync(resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeReceiptResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeReceiptResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeLayoutAsync(this.getEndpoint(), this.getApiVersion(), pagesConverted, language, readingOrder, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeLayoutAsync(this.getEndpoint(), this.getApiVersion(), pagesConverted, language, readingOrder, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeLayoutAsyncWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeLayoutAsyncWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeLayoutAsyncAsync(contentType, pages, language, readingOrder, fileStream, contentLength).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeLayoutAsyncResponse analyzeLayoutAsyncWithResponse(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (AnalyzeLayoutAsyncResponse)((Object)this.analyzeLayoutAsyncWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.analyzeLayoutAsync(this.getEndpoint(), this.getApiVersion(), pagesConverted, language, readingOrder, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(pages, CollectionFormat.CSV);
        return this.service.analyzeLayoutAsync(this.getEndpoint(), this.getApiVersion(), pagesConverted, language, readingOrder, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        return this.analyzeLayoutAsyncWithResponseAsync(pages, language, readingOrder, fileStream).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsyncAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return this.analyzeLayoutAsyncWithResponseAsync(pages, language, readingOrder, fileStream, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeLayoutAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        this.analyzeLayoutAsyncAsync(pages, language, readingOrder, fileStream).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeLayoutAsyncResponse analyzeLayoutAsyncWithResponse(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return (AnalyzeLayoutAsyncResponse)((Object)this.analyzeLayoutAsyncWithResponseAsync(pages, language, readingOrder, fileStream, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeLayoutResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeLayoutResult(this.getEndpoint(), this.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId) {
        return this.getAnalyzeLayoutResultWithResponseAsync(resultId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeLayoutResultWithResponseAsync(resultId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AnalyzeOperationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeLayoutResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeLayoutResultAsync(resultId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeLayoutResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeLayoutResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsSinglePageAsync() {
        String op = "full";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCustomModels(this.getEndpoint(), this.getApiVersion(), "full", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsSinglePageAsync(Context context) {
        String op = "full";
        String accept = "application/json";
        return this.service.listCustomModels(this.getEndpoint(), this.getApiVersion(), "full", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listCustomModelsAsync() {
        return new PagedFlux(() -> this.listCustomModelsSinglePageAsync(), nextLink -> this.listCustomModelsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listCustomModelsAsync(Context context) {
        return new PagedFlux(() -> this.listCustomModelsSinglePageAsync(context), nextLink -> this.listCustomModelsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> listCustomModels() {
        return new PagedIterable(this.listCustomModelsAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> listCustomModels(Context context) {
        return new PagedIterable(this.listCustomModelsAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Models>> getCustomModelsWithResponseAsync() {
        String op = "summary";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCustomModels(this.getEndpoint(), this.getApiVersion(), "summary", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Models>> getCustomModelsWithResponseAsync(Context context) {
        String op = "summary";
        String accept = "application/json";
        return this.service.getCustomModels(this.getEndpoint(), this.getApiVersion(), "summary", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Models> getCustomModelsAsync() {
        return this.getCustomModelsWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Models)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Models> getCustomModelsAsync(Context context) {
        return this.getCustomModelsWithResponseAsync(context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Models)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Models getCustomModels() {
        return (Models)this.getCustomModelsAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Models> getCustomModelsWithResponse(Context context) {
        return (Response)this.getCustomModelsWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listCustomModelsNext(nextLink, this.getEndpoint(), this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listCustomModelsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listCustomModelsNext(nextLink, this.getEndpoint(), this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}/formrecognizer/{ApiVersion}")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface FormRecognizerClientService {
        @Post(value="/custom/models")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @BodyParam(value="application/json") TrainRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/custom/models/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Model>> getCustomModel(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeKeys") Boolean var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/custom/models/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteCustomModel(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModel(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeTextDetails") Boolean var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModel(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeTextDetails") Boolean var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/custom/models/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeFormResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @PathParam(value="resultId") UUID var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/custom/models/{modelId}/copy")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<CopyCustomModelResponse> copyCustomModel(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @BodyParam(value="application/json") CopyRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/custom/models/{modelId}/copyResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<CopyOperationResult>> getCustomModelCopyResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @PathParam(value="resultId") UUID var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/custom/models/copyAuthorization")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<GenerateModelCopyAuthorizationResponse> generateModelCopyAuthorization(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/custom/models/compose")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ComposeCustomModelsAsyncResponse> composeCustomModelsAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @BodyParam(value="application/json") ComposeRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeBusinessCardAsyncResponse> analyzeBusinessCardAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/prebuilt/businessCard/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeInvoiceAsyncResponse> analyzeInvoiceAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/prebuilt/invoice/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeIdDocumentAsyncResponse> analyzeIdDocumentAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @BodyParam(value="application/json") SourcePath var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/prebuilt/idDocument/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/prebuilt/receipt/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsync(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/layout/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/custom/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Models>> listCustomModels(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="op") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/custom/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Models>> getCustomModels(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="op") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Models>> listCustomModelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HostParam(value="ApiVersion") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

