/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.models.FormRecognizerErrorInformation;
import com.azure.core.exception.AzureException;
import com.azure.core.util.CoreUtils;
import java.util.Collections;
import java.util.List;

public class FormRecognizerException
extends AzureException {
    private final List<FormRecognizerErrorInformation> errorInformationList;
    private final String errorInformationMessage;

    public FormRecognizerException(String message, List<FormRecognizerErrorInformation> errorInformationList) {
        super(message);
        StringBuilder errorInformationStringBuilder = new StringBuilder().append(message);
        if (!CoreUtils.isNullOrEmpty(errorInformationList)) {
            for (FormRecognizerErrorInformation errorInformation : errorInformationList) {
                errorInformationStringBuilder.append(", errorCode: [").append(errorInformation.getErrorCode()).append("], ").append("message").append(": ").append(errorInformation.getMessage());
            }
            this.errorInformationList = Collections.unmodifiableList(errorInformationList);
        } else {
            this.errorInformationList = null;
        }
        this.errorInformationMessage = errorInformationStringBuilder.toString();
    }

    public String getMessage() {
        return this.errorInformationMessage;
    }

    public List<FormRecognizerErrorInformation> getErrorInformation() {
        return this.errorInformationList;
    }
}

