/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.models.FieldBoundingBox;
import com.azure.ai.formrecognizer.models.FormElement;
import java.util.Collections;
import java.util.List;

public final class FormTableCell
extends FormElement {
    private final int rowIndex;
    private final int columnIndex;
    private final int rowSpan;
    private final int columnSpan;
    private final float confidence;
    private final List<FormElement> fieldElements;
    private final boolean isHeader;
    private final boolean isFooter;

    public FormTableCell(int rowIndex, int columnIndex, int rowSpan, int columnSpan, String text, FieldBoundingBox boundingBox, float confidence, boolean isHeader, boolean isFooter, int pageNumber, List<FormElement> fieldElements) {
        super(text, boundingBox, pageNumber);
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
        this.confidence = confidence;
        this.isHeader = isHeader;
        this.isFooter = isFooter;
        this.fieldElements = fieldElements == null ? null : Collections.unmodifiableList(fieldElements);
    }

    public float getConfidence() {
        return this.confidence;
    }

    @Override
    public int getPageNumber() {
        return super.getPageNumber();
    }

    @Override
    public FieldBoundingBox getBoundingBox() {
        return super.getBoundingBox();
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public List<FormElement> getFieldElements() {
        return this.fieldElements;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isFooter() {
        return this.isFooter;
    }
}

