/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training.models;

import com.azure.ai.formrecognizer.implementation.CustomFormModelHelper;
import com.azure.ai.formrecognizer.models.FormRecognizerError;
import com.azure.ai.formrecognizer.training.models.CustomFormModelProperties;
import com.azure.ai.formrecognizer.training.models.CustomFormModelStatus;
import com.azure.ai.formrecognizer.training.models.CustomFormSubmodel;
import com.azure.ai.formrecognizer.training.models.TrainingDocumentInfo;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;

public final class CustomFormModel {
    private final List<FormRecognizerError> modelError;
    private final String modelId;
    private final CustomFormModelStatus modelStatus;
    private final OffsetDateTime trainingStartedOn;
    private final OffsetDateTime trainingCompletedOn;
    private final List<CustomFormSubmodel> submodels;
    private List<TrainingDocumentInfo> trainingDocuments;
    private String modelName;
    private CustomFormModelProperties customFormModelProperties;

    public CustomFormModel(String modelId, CustomFormModelStatus modelStatus, OffsetDateTime trainingStartedOn, OffsetDateTime trainingCompletedOn, List<CustomFormSubmodel> submodels, List<FormRecognizerError> modelError, List<TrainingDocumentInfo> trainingDocuments) {
        this.modelId = modelId;
        this.modelStatus = modelStatus;
        this.trainingStartedOn = trainingStartedOn;
        this.trainingCompletedOn = trainingCompletedOn;
        this.submodels = submodels == null ? null : Collections.unmodifiableList(submodels);
        this.modelError = modelError == null ? null : Collections.unmodifiableList(modelError);
        this.trainingDocuments = trainingDocuments == null ? null : Collections.unmodifiableList(trainingDocuments);
    }

    public String getModelId() {
        return this.modelId;
    }

    public CustomFormModelStatus getModelStatus() {
        return this.modelStatus;
    }

    public OffsetDateTime getTrainingStartedOn() {
        return this.trainingStartedOn;
    }

    public OffsetDateTime getTrainingCompletedOn() {
        return this.trainingCompletedOn;
    }

    public List<FormRecognizerError> getModelError() {
        return this.modelError;
    }

    public List<CustomFormSubmodel> getSubmodels() {
        return this.submodels;
    }

    public List<TrainingDocumentInfo> getTrainingDocuments() {
        return this.trainingDocuments;
    }

    public CustomFormModelProperties getCustomModelProperties() {
        return this.customFormModelProperties;
    }

    public String getModelName() {
        return this.modelName;
    }

    private void setTrainingDocuments(List<TrainingDocumentInfo> trainingDocuments) {
        this.trainingDocuments = trainingDocuments;
    }

    private void setModelName(String modelName) {
        this.modelName = modelName;
    }

    private void setCustomFormModelProperties(CustomFormModelProperties customFormModelProperties) {
        this.customFormModelProperties = customFormModelProperties;
    }

    static {
        CustomFormModelHelper.setAccessor(new CustomFormModelHelper.CustomFormModelAccessor(){

            @Override
            public void setTrainingDocuments(CustomFormModel formModel, List<TrainingDocumentInfo> trainingDocuments) {
                formModel.setTrainingDocuments(trainingDocuments);
            }

            @Override
            public void setModelName(CustomFormModel formModel, String modelName) {
                formModel.setModelName(modelName);
            }

            @Override
            public void setCustomFormModelProperties(CustomFormModel formModel, CustomFormModelProperties customFormModelProperties) {
                formModel.setCustomFormModelProperties(customFormModelProperties);
            }
        });
    }
}

