// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Address field value. */
@Immutable
public final class AddressValue {
    /*
     * House or building number.
     */
    @JsonProperty(value = "houseNumber")
    private String houseNumber;

    /*
     * Post office box number.
     */
    @JsonProperty(value = "poBox")
    private String poBox;

    /*
     * Street name.
     */
    @JsonProperty(value = "road")
    private String road;

    /*
     * Name of city, town, village, etc.
     */
    @JsonProperty(value = "city")
    private String city;

    /*
     * First-level administrative division.
     */
    @JsonProperty(value = "state")
    private String state;

    /*
     * Postal code used for mail sorting.
     */
    @JsonProperty(value = "postalCode")
    private String postalCode;

    /*
     * Country/region.
     */
    @JsonProperty(value = "countryRegion")
    private String countryRegion;

    /*
     * Street-level address, excluding city, state, countryRegion, and postalCode.
     */
    @JsonProperty(value = "streetAddress")
    private String streetAddress;

    /*
     * Apartment or office number
     */
    @JsonProperty(value = "unit")
    private String unit;

    /*
     * Districts or boroughs within a city, such as Brooklyn in New York City or City of Westminster in London.
     */
    @JsonProperty(value = "cityDistrict")
    private String cityDistrict;

    /*
     * Second-level administrative division used in certain locales.
     */
    @JsonProperty(value = "stateDistrict")
    private String stateDistrict;

    /*
     * Unofficial neighborhood name, like Chinatown.
     */
    @JsonProperty(value = "suburb")
    private String suburb;

    /*
     * Build name, such as World Trade Center.
     */
    @JsonProperty(value = "house")
    private String house;

    /*
     * Floor number, such as 3F.
     */
    @JsonProperty(value = "level")
    private String level;

    /** Creates an instance of AddressValue class. */
    private AddressValue() {}

    /**
     * Get the houseNumber property: House or building number.
     *
     * @return the houseNumber value.
     */
    public String getHouseNumber() {
        return this.houseNumber;
    }

    /**
     * Get the poBox property: Post office box number.
     *
     * @return the poBox value.
     */
    public String getPoBox() {
        return this.poBox;
    }

    /**
     * Get the road property: Street name.
     *
     * @return the road value.
     */
    public String getRoad() {
        return this.road;
    }

    /**
     * Get the city property: Name of city, town, village, etc.
     *
     * @return the city value.
     */
    public String getCity() {
        return this.city;
    }

    /**
     * Get the state property: First-level administrative division.
     *
     * @return the state value.
     */
    public String getState() {
        return this.state;
    }

    /**
     * Get the postalCode property: Postal code used for mail sorting.
     *
     * @return the postalCode value.
     */
    public String getPostalCode() {
        return this.postalCode;
    }

    /**
     * Get the countryRegion property: Country/region.
     *
     * @return the countryRegion value.
     */
    public String getCountryRegion() {
        return this.countryRegion;
    }

    /**
     * Get the streetAddress property: Street-level address, excluding city, state, countryRegion, and postalCode.
     *
     * @return the streetAddress value.
     */
    public String getStreetAddress() {
        return this.streetAddress;
    }

    /**
     * Get the unit property: Apartment or office number.
     *
     * @return the unit value.
     */
    public String getUnit() {
        return this.unit;
    }

    /**
     * Get the cityDistrict property: Districts or boroughs within a city, such as Brooklyn in New York City or City of
     * Westminster in London.
     *
     * @return the cityDistrict value.
     */
    public String getCityDistrict() {
        return this.cityDistrict;
    }

    /**
     * Get the stateDistrict property: Second-level administrative division used in certain locales.
     *
     * @return the stateDistrict value.
     */
    public String getStateDistrict() {
        return this.stateDistrict;
    }

    /**
     * Get the suburb property: Unofficial neighborhood name, like Chinatown.
     *
     * @return the suburb value.
     */
    public String getSuburb() {
        return this.suburb;
    }

    /**
     * Get the house property: Build name, such as World Trade Center.
     *
     * @return the house value.
     */
    public String getHouse() {
        return this.house;
    }

    /**
     * Get the level property: Floor number, such as 3F.
     *
     * @return the level value.
     */
    public String getLevel() {
        return this.level;
    }
}
