// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Status and result of the analyze operation. */
@Immutable
public final class AnalyzeResultOperation {
    /*
     * Operation status.
     */
    @JsonProperty(value = "status", required = true)
    private AnalyzeResultOperationStatus status;

    /*
     * Date and time (UTC) when the analyze operation was submitted.
     */
    @JsonProperty(value = "createdDateTime", required = true)
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    @JsonProperty(value = "lastUpdatedDateTime", required = true)
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * Encountered error during document analysis.
     */
    @JsonProperty(value = "error")
    private Error error;

    /*
     * Document analysis result.
     */
    @JsonProperty(value = "analyzeResult")
    private AnalyzeResult analyzeResult;

    /**
     * Creates an instance of AnalyzeResultOperation class.
     *
     * @param status the status value to set.
     * @param createdDateTime the createdDateTime value to set.
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     */
    @JsonCreator
    private AnalyzeResultOperation(
            @JsonProperty(value = "status", required = true) AnalyzeResultOperationStatus status,
            @JsonProperty(value = "createdDateTime", required = true) OffsetDateTime createdDateTime,
            @JsonProperty(value = "lastUpdatedDateTime", required = true) OffsetDateTime lastUpdatedDateTime) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    /**
     * Get the status property: Operation status.
     *
     * @return the status value.
     */
    public AnalyzeResultOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the analyze operation was submitted.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     *
     * @return the lastUpdatedDateTime value.
     */
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Get the error property: Encountered error during document analysis.
     *
     * @return the error value.
     */
    public Error getError() {
        return this.error;
    }

    /**
     * Get the analyzeResult property: Document analysis result.
     *
     * @return the analyzeResult value.
     */
    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }
}
