// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Classifier document type info. */
@Fluent
public final class ClassifierDocumentTypeDetails {
    /*
     * Type of training data source.
     */
    @JsonProperty(value = "sourceKind")
    private ContentSourceKind sourceKind;

    /*
     * Azure Blob Storage location containing the training data for a classifier document type.  Either azureBlobSource
     * or azureBlobFileListSource must be specified.
     */
    @JsonProperty(value = "azureBlobSource")
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data for a classifier document type.  Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @JsonProperty(value = "azureBlobFileListSource")
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /** Creates an instance of ClassifierDocumentTypeDetails class. */
    public ClassifierDocumentTypeDetails() {}

    /**
     * Get the sourceKind property: Type of training data source.
     *
     * @return the sourceKind value.
     */
    public ContentSourceKind getSourceKind() {
        return this.sourceKind;
    }

    /**
     * Set the sourceKind property: Type of training data source.
     *
     * @param sourceKind the sourceKind value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    public ClassifierDocumentTypeDetails setSourceKind(ContentSourceKind sourceKind) {
        this.sourceKind = sourceKind;
        return this;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @return the azureBlobSource value.
     */
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Set the azureBlobSource property: Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @param azureBlobSource the azureBlobSource value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    public ClassifierDocumentTypeDetails setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data for a
     * classifier document type. Either azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @return the azureBlobFileListSource value.
     */
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Set the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data for a
     * classifier document type. Either azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @param azureBlobFileListSource the azureBlobFileListSource value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    public ClassifierDocumentTypeDetails setAzureBlobFileListSource(
            AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }
}
