// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Document classification parameters. */
@Fluent
public final class ClassifyDocumentRequest {
    /*
     * Document URL to classify.  Either urlSource or base64Source must be specified.
     */
    @JsonProperty(value = "urlSource")
    private String urlSource;

    /*
     * Base64 encoding of the document to classify.  Either urlSource or base64Source must be specified.
     */
    @JsonProperty(value = "base64Source")
    private byte[] base64Source;

    /** Creates an instance of ClassifyDocumentRequest class. */
    public ClassifyDocumentRequest() {}

    /**
     * Get the urlSource property: Document URL to classify. Either urlSource or base64Source must be specified.
     *
     * @return the urlSource value.
     */
    public String getUrlSource() {
        return this.urlSource;
    }

    /**
     * Set the urlSource property: Document URL to classify. Either urlSource or base64Source must be specified.
     *
     * @param urlSource the urlSource value to set.
     * @return the ClassifyDocumentRequest object itself.
     */
    public ClassifyDocumentRequest setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    /**
     * Get the base64Source property: Base64 encoding of the document to classify. Either urlSource or base64Source must
     * be specified.
     *
     * @return the base64Source value.
     */
    public byte[] getBase64Source() {
        return CoreUtils.clone(this.base64Source);
    }

    /**
     * Set the base64Source property: Base64 encoding of the document to classify. Either urlSource or base64Source must
     * be specified.
     *
     * @param base64Source the base64Source value to set.
     * @return the ClassifyDocumentRequest object itself.
     */
    public ClassifyDocumentRequest setBase64Source(byte[] base64Source) {
        this.base64Source = CoreUtils.clone(base64Source);
        return this;
    }
}
