// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Type of content source. */
public enum ContentSourceKind {
    /** Enum value url. */
    URL("url"),

    /** Enum value base64. */
    BASE64("base64"),

    /** Enum value azureBlob. */
    AZURE_BLOB("azureBlob"),

    /** Enum value azureBlobFileList. */
    AZURE_BLOB_FILE_LIST("azureBlobFileList");

    /** The actual serialized value for a ContentSourceKind instance. */
    private final String value;

    ContentSourceKind(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ContentSourceKind instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ContentSourceKind object, or null if unable to parse.
     */
    @JsonCreator
    public static ContentSourceKind fromString(String value) {
        if (value == null) {
            return null;
        }
        ContentSourceKind[] items = ContentSourceKind.values();
        for (ContentSourceKind item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
