// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Content type for upload. */
public enum ContentType {
    /** Enum value application/octet-stream. */
    APPLICATION_OCTET_STREAM("application/octet-stream"),

    /** Enum value application/pdf. */
    APPLICATION_PDF("application/pdf"),

    /** Enum value application/vnd.openxmlformats-officedocument.presentationml.presentation. */
    APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION(
            "application/vnd.openxmlformats-officedocument.presentationml.presentation"),

    /** Enum value application/vnd.openxmlformats-officedocument.spreadsheetml.sheet. */
    APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET(
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),

    /** Enum value application/vnd.openxmlformats-officedocument.wordprocessingml.document. */
    APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT(
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document"),

    /** Enum value image/bmp. */
    IMAGE_BMP("image/bmp"),

    /** Enum value image/heif. */
    IMAGE_HEIF("image/heif"),

    /** Enum value image/jpeg. */
    IMAGE_JPEG("image/jpeg"),

    /** Enum value image/png. */
    IMAGE_PNG("image/png"),

    /** Enum value image/tiff. */
    IMAGE_TIFF("image/tiff");

    /** The actual serialized value for a ContentType instance. */
    private final String value;

    ContentType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ContentType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ContentType object, or null if unable to parse.
     */
    @JsonCreator
    public static ContentType fromString(String value) {
        if (value == null) {
            return null;
        }
        ContentType[] items = ContentType.values();
        for (ContentType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
