// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Authorization to copy a document model to the specified target resource and modelId. */
@Immutable
public final class CopyAuthorization {
    /*
     * ID of the target Azure resource where the document model should be copied to.
     */
    @JsonProperty(value = "targetResourceId", required = true)
    private String targetResourceId;

    /*
     * Location of the target Azure resource where the document model should be copied to.
     */
    @JsonProperty(value = "targetResourceRegion", required = true)
    private String targetResourceRegion;

    /*
     * Identifier of the target document model.
     */
    @JsonProperty(value = "targetModelId", required = true)
    private String targetModelId;

    /*
     * URL of the copied document model in the target account.
     */
    @JsonProperty(value = "targetModelLocation", required = true)
    private String targetModelLocation;

    /*
     * Token used to authorize the request.
     */
    @JsonProperty(value = "accessToken", required = true)
    private String accessToken;

    /*
     * Date/time when the access token expires.
     */
    @JsonProperty(value = "expirationDateTime", required = true)
    private OffsetDateTime expirationDateTime;

    /**
     * Creates an instance of CopyAuthorization class.
     *
     * @param targetResourceId the targetResourceId value to set.
     * @param targetResourceRegion the targetResourceRegion value to set.
     * @param targetModelId the targetModelId value to set.
     * @param targetModelLocation the targetModelLocation value to set.
     * @param accessToken the accessToken value to set.
     * @param expirationDateTime the expirationDateTime value to set.
     */
    @JsonCreator
    public CopyAuthorization(
            @JsonProperty(value = "targetResourceId", required = true) String targetResourceId,
            @JsonProperty(value = "targetResourceRegion", required = true) String targetResourceRegion,
            @JsonProperty(value = "targetModelId", required = true) String targetModelId,
            @JsonProperty(value = "targetModelLocation", required = true) String targetModelLocation,
            @JsonProperty(value = "accessToken", required = true) String accessToken,
            @JsonProperty(value = "expirationDateTime", required = true) OffsetDateTime expirationDateTime) {
        this.targetResourceId = targetResourceId;
        this.targetResourceRegion = targetResourceRegion;
        this.targetModelId = targetModelId;
        this.targetModelLocation = targetModelLocation;
        this.accessToken = accessToken;
        this.expirationDateTime = expirationDateTime;
    }

    /**
     * Get the targetResourceId property: ID of the target Azure resource where the document model should be copied to.
     *
     * @return the targetResourceId value.
     */
    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Get the targetResourceRegion property: Location of the target Azure resource where the document model should be
     * copied to.
     *
     * @return the targetResourceRegion value.
     */
    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    /**
     * Get the targetModelId property: Identifier of the target document model.
     *
     * @return the targetModelId value.
     */
    public String getTargetModelId() {
        return this.targetModelId;
    }

    /**
     * Get the targetModelLocation property: URL of the copied document model in the target account.
     *
     * @return the targetModelLocation value.
     */
    public String getTargetModelLocation() {
        return this.targetModelLocation;
    }

    /**
     * Get the accessToken property: Token used to authorize the request.
     *
     * @return the accessToken value.
     */
    public String getAccessToken() {
        return this.accessToken;
    }

    /**
     * Get the expirationDateTime property: Date/time when the access token expires.
     *
     * @return the expirationDateTime value.
     */
    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }
}
