// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/** Document classifier info. */
@Immutable
public final class DocumentClassifierDetails {
    /*
     * Unique document classifier name.
     */
    @JsonProperty(value = "classifierId", required = true)
    private String classifierId;

    /*
     * Document classifier description.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Date and time (UTC) when the document classifier was created.
     */
    @JsonProperty(value = "createdDateTime", required = true)
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the document classifier will expire.
     */
    @JsonProperty(value = "expirationDateTime")
    private OffsetDateTime expirationDateTime;

    /*
     * API version used to create this document classifier.
     */
    @JsonProperty(value = "apiVersion", required = true)
    private String apiVersion;

    /*
     * List of document types to classify against.
     */
    @JsonProperty(value = "docTypes", required = true)
    private Map<String, ClassifierDocumentTypeDetails> docTypes;

    /**
     * Creates an instance of DocumentClassifierDetails class.
     *
     * @param classifierId the classifierId value to set.
     * @param createdDateTime the createdDateTime value to set.
     * @param apiVersion the apiVersion value to set.
     * @param docTypes the docTypes value to set.
     */
    @JsonCreator
    private DocumentClassifierDetails(
            @JsonProperty(value = "classifierId", required = true) String classifierId,
            @JsonProperty(value = "createdDateTime", required = true) OffsetDateTime createdDateTime,
            @JsonProperty(value = "apiVersion", required = true) String apiVersion,
            @JsonProperty(value = "docTypes", required = true) Map<String, ClassifierDocumentTypeDetails> docTypes) {
        this.classifierId = classifierId;
        this.createdDateTime = createdDateTime;
        this.apiVersion = apiVersion;
        this.docTypes = docTypes;
    }

    /**
     * Get the classifierId property: Unique document classifier name.
     *
     * @return the classifierId value.
     */
    public String getClassifierId() {
        return this.classifierId;
    }

    /**
     * Get the description property: Document classifier description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the document classifier was created.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the expirationDateTime property: Date and time (UTC) when the document classifier will expire.
     *
     * @return the expirationDateTime value.
     */
    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Get the apiVersion property: API version used to create this document classifier.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the docTypes property: List of document types to classify against.
     *
     * @return the docTypes value.
     */
    public Map<String, ClassifierDocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }
}
