/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetOperationsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class MiscellaneousImpl {
    private final MiscellaneousService service;
    private final FormRecognizerClientImpl client;

    MiscellaneousImpl(FormRecognizerClientImpl client) {
        this.service = (MiscellaneousService)RestProxy.create(MiscellaneousService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> listOperationsSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperations(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> listOperationsSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.listOperations(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> listOperationsAsync() {
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> listOperationsAsync(Context context) {
        return new PagedFlux(() -> this.listOperationsSinglePageAsync(context), nextLink -> this.listOperationsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> listOperationsSinglePage() {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.listOperationsSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> listOperationsSinglePage(Context context) {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.listOperationsSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> listOperations() {
        return new PagedIterable(() -> this.listOperationsSinglePage(Context.NONE), nextLink -> this.listOperationsNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> listOperations(Context context) {
        return new PagedIterable(() -> this.listOperationsSinglePage(context), nextLink -> this.listOperationsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponseAsync(String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperation(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationAsync(String operationId) {
        return this.getOperationWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty((Object)((OperationDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationAsync(String operationId, Context context) {
        return this.getOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty((Object)((OperationDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationDetails> getOperationWithResponse(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getOperationSync(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationDetails getOperation(String operationId) {
        return (OperationDetails)this.getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceInfoWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getResourceInfo(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceInfoWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.getResourceInfo(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceInfoAsync() {
        return this.getResourceInfoWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((ResourceDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceInfoAsync(Context context) {
        return this.getResourceInfoWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((ResourceDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceDetails> getResourceInfoWithResponse(Context context) {
        String accept = "application/json";
        return this.service.getResourceInfoSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceDetails getResourceInfo() {
        return (ResourceDetails)this.getResourceInfoWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> listOperationsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOperationsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> listOperationsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listOperationsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> listOperationsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.listOperationsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<OperationSummary> listOperationsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<GetOperationsResponse> res = this.service.listOperationsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetOperationsResponse)res.getValue()).getValue(), ((GetOperationsResponse)res.getValue()).getNextLink(), null);
    }

    @Host(value="{endpoint}/formrecognizer")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface MiscellaneousService {
        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationsResponse>> listOperations(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetOperationsResponse> listOperationsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<OperationDetails>> getOperation(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<OperationDetails> getOperationSync(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ResourceDetails>> getResourceInfo(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/info")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ResourceDetails> getResourceInfoSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetOperationsResponse>> listOperationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetOperationsResponse> listOperationsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

