/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.Transforms;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Constants;
import com.azure.ai.formrecognizer.implementation.AnalyzersImpl;
import com.azure.ai.formrecognizer.implementation.CustomModelsImpl;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeBusinessCardHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeIdDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeInvoiceHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeLayoutHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeReceiptHeaders;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormRecognizerErrorInformation;
import com.azure.ai.formrecognizer.models.FormRecognizerException;
import com.azure.ai.formrecognizer.models.FormRecognizerLocale;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.models.RecognizeBusinessCardsOptions;
import com.azure.ai.formrecognizer.models.RecognizeContentOptions;
import com.azure.ai.formrecognizer.models.RecognizeCustomFormsOptions;
import com.azure.ai.formrecognizer.models.RecognizeIdentityDocumentOptions;
import com.azure.ai.formrecognizer.models.RecognizeInvoicesOptions;
import com.azure.ai.formrecognizer.models.RecognizeReceiptsOptions;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

@ServiceClient(builder=FormRecognizerClientBuilder.class)
public final class FormRecognizerClient {
    private static final ClientLogger LOGGER = new ClientLogger(FormRecognizerClient.class);
    private final AnalyzersImpl analyzersImpl;
    private final CustomModelsImpl customModelsImpl;

    FormRecognizerClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.analyzersImpl = service.getAnalyzers();
        this.customModelsImpl = service.getCustomModels();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl) {
        return this.beginRecognizeCustomFormsFromUrl(modelId, formUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        return this.beginRecognizeCustomFormsFromUrlInternal(formUrl, modelId, recognizeCustomFormsOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrlInternal(String formUrl, String modelId, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)formUrl)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'formUrl' is required and cannot be null or empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions = Utility.getRecognizeCustomFormOptions(recognizeCustomFormsOptions);
        UUID modelUuid = UUID.fromString(modelId);
        boolean isFieldElementsIncluded = finalRecognizeCustomFormsOptions.isFieldElementsIncluded();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.analyzeActivationOperation(modelUuid, formUrl, null, null, 0L, isFieldElementsIncluded, finalRecognizeCustomFormsOptions, context).apply((PollingContext<FormRecognizerOperationResult>)cxt)), this.pollingOperation(resultUid -> this.customModelsImpl.getAnalyzeResultWithResponse(modelUuid, (UUID)resultUid, context)), this.getCancellationIsNotSupported(), this.fetchingOperation(resultId -> this.customModelsImpl.getAnalyzeResultWithResponse(modelUuid, (UUID)resultId, context), isFieldElementsIncluded, modelId));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, InputStream form, long length) {
        return this.beginRecognizeCustomForms(modelId, form, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, InputStream form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        return this.beginRecognizeCustomFormsInternal(modelId, form, length, recognizeCustomFormsOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsInternal(String modelId, InputStream form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        if (form == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'form' is required and cannot be null or empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions = Utility.getRecognizeCustomFormOptions(recognizeCustomFormsOptions);
        UUID modelUuid = UUID.fromString(modelId);
        boolean isFieldElementsIncluded = finalRecognizeCustomFormsOptions.isFieldElementsIncluded();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.analyzeActivationOperation(modelUuid, null, finalRecognizeCustomFormsOptions.getContentType(), BinaryData.fromStream((InputStream)form), length, isFieldElementsIncluded, finalRecognizeCustomFormsOptions, context).apply((PollingContext<FormRecognizerOperationResult>)cxt));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultUid -> this.customModelsImpl.getAnalyzeResultWithResponse(modelUuid, (UUID)resultUid, context)), this.getCancellationIsNotSupported(), this.fetchingOperation(resultId -> this.customModelsImpl.getAnalyzeResultWithResponse(modelUuid, (UUID)resultId, context), isFieldElementsIncluded, modelId));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl) {
        return this.beginRecognizeContentFromUrl(formUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl, RecognizeContentOptions recognizeContentOptions, Context context) {
        return this.beginRecognizeContentFromUrlInternal(formUrl, recognizeContentOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrlInternal(String formUrl, RecognizeContentOptions recognizeContentOptions, Context context) {
        if (formUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'formUrl' is required and cannot be null."));
        }
        RecognizeContentOptions finalRecognizeContentOptions = Utility.getRecognizeContentOptions(recognizeContentOptions);
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse = this.analyzersImpl.analyzeLayoutWithResponse(finalRecognizeContentOptions.getPages(), Language.fromString(Objects.toString((Object)finalRecognizeContentOptions.getLanguage(), null)), ReadingOrder.fromString(Objects.toString((Object)finalRecognizeContentOptions.getReadingOrder(), null)), new SourcePath().setSource(formUrl), context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeLayoutHeaders)analyzeLayoutWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> {
            try {
                return this.analyzersImpl.getAnalyzeLayoutResultWithResponse((UUID)resultId, context);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedLayout(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeLayoutResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), true);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(InputStream form, long length) {
        return this.beginRecognizeContent(form, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(InputStream form, long length, RecognizeContentOptions recognizeContentOptions, Context context) {
        return this.beginRecognizeContentInternal(form, length, recognizeContentOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentInternal(InputStream form, long length, RecognizeContentOptions recognizeContentOptions, Context context) {
        if (form == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'form' is required and cannot be null."));
        }
        RecognizeContentOptions finalRecognizeContentOptions = Utility.getRecognizeContentOptions(recognizeContentOptions);
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse = this.analyzersImpl.analyzeLayoutWithResponse(finalRecognizeContentOptions.getContentType() != null ? ContentType.fromString(finalRecognizeContentOptions.getContentType().toString()) : null, finalRecognizeContentOptions.getPages(), Language.fromString(Objects.toString((Object)finalRecognizeContentOptions.getLanguage(), null)), ReadingOrder.fromString(Objects.toString((Object)finalRecognizeContentOptions.getReadingOrder(), null)), BinaryData.fromStream((InputStream)form), (Long)length, context);
            return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeLayoutHeaders)analyzeLayoutWithResponse.getDeserializedHeaders()).getOperationLocation())));
        }, this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeLayoutResultWithResponse((UUID)resultId, context)), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedLayout(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeLayoutResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), true);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl) {
        return this.beginRecognizeReceiptsFromUrl(receiptUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        return this.beginRecognizeReceiptsFromUrlInternal(receiptUrl, recognizeReceiptsOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrlInternal(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        if (receiptUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'receiptUrl' is required and cannot be null."));
        }
        RecognizeReceiptsOptions finalRecognizeReceiptsOptions = Utility.getRecognizeReceiptOptions(recognizeReceiptsOptions);
        boolean isFieldElementsIncluded = finalRecognizeReceiptsOptions.isFieldElementsIncluded();
        FormRecognizerLocale localeInfo = finalRecognizeReceiptsOptions.getLocale();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse = this.analyzersImpl.analyzeReceiptWithResponse(isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeReceiptsOptions.getPages(), new SourcePath().setSource(receiptUrl), context);
            return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeReceiptHeaders)analyzeReceiptWithResponse.getDeserializedHeaders()).getOperationLocation())));
        }, this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeReceiptResultWithResponse((UUID)resultId, context)), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeReceiptResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), true, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(InputStream receipt, long length) {
        return this.beginRecognizeReceipts(receipt, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(InputStream receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        return this.beginRecognizeReceiptsInternal(receipt, length, recognizeReceiptsOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsInternal(InputStream receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        if (receipt == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'receipt' is required and cannot be null."));
        }
        RecognizeReceiptsOptions finalRecognizeReceiptsOptions = Utility.getRecognizeReceiptOptions(recognizeReceiptsOptions);
        boolean isFieldElementsIncluded = finalRecognizeReceiptsOptions.isFieldElementsIncluded();
        FormRecognizerLocale localeInfo = finalRecognizeReceiptsOptions.getLocale();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse = this.analyzersImpl.analyzeReceiptWithResponse(finalRecognizeReceiptsOptions.getContentType() != null ? ContentType.fromString(finalRecognizeReceiptsOptions.getContentType().toString()) : null, (Boolean)isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeReceiptsOptions.getPages(), BinaryData.fromStream((InputStream)receipt), (Long)length, context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeReceiptHeaders)analyzeReceiptWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> {
            try {
                return this.analyzersImpl.getAnalyzeReceiptResultWithResponse((UUID)resultId, context);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeReceiptResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), isFieldElementsIncluded, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl) {
        return this.beginRecognizeBusinessCardsFromUrl(businessCardUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        return this.beginRecognizeBusinessCardsFromUrlInternal(businessCardUrl, recognizeBusinessCardsOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrlInternal(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        if (businessCardUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'businessCardUrl' is required and cannot be null."));
        }
        RecognizeBusinessCardsOptions finalRecognizeBusinessCardsOptions = Utility.getRecognizeBusinessCardsOptions(recognizeBusinessCardsOptions);
        boolean isFieldElementsIncluded = finalRecognizeBusinessCardsOptions.isFieldElementsIncluded();
        FormRecognizerLocale localeInfo = finalRecognizeBusinessCardsOptions.getLocale();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse = this.analyzersImpl.analyzeBusinessCardWithResponse(isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeBusinessCardsOptions.getPages(), new SourcePath().setSource(businessCardUrl), context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeBusinessCardHeaders)analyzeBusinessCardWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> {
            try {
                return this.analyzersImpl.getAnalyzeBusinessCardResultWithResponse((UUID)resultId, context);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeBusinessCardResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), true, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(InputStream businessCard, long length) {
        return this.beginRecognizeBusinessCards(businessCard, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(InputStream businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        return this.beginRecognizeBusinessCardsInternal(businessCard, length, recognizeBusinessCardsOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsInternal(InputStream businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        if (businessCard == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'businessCard' is required and cannot be null."));
        }
        RecognizeBusinessCardsOptions finalBusinessCardOptions = Utility.getRecognizeBusinessCardsOptions(recognizeBusinessCardsOptions);
        boolean isFieldElementsIncluded = finalBusinessCardOptions.isFieldElementsIncluded();
        FormRecognizerLocale localeInfo = finalBusinessCardOptions.getLocale();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse = this.analyzersImpl.analyzeBusinessCardWithResponse(finalBusinessCardOptions.getContentType() != null ? ContentType.fromString(finalBusinessCardOptions.getContentType().toString()) : null, (Boolean)isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalBusinessCardOptions.getPages(), BinaryData.fromStream((InputStream)businessCard), (Long)length, context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeBusinessCardHeaders)analyzeBusinessCardWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeBusinessCardResultWithResponse((UUID)resultId, context)), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeBusinessCardResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), isFieldElementsIncluded, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl) {
        return this.beginRecognizeInvoicesFromUrl(invoiceUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        return this.beginRecognizeInvoicesFromUrlInternal(invoiceUrl, recognizeInvoicesOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrlInternal(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        if (invoiceUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'invoiceUrl' is required and cannot be null."));
        }
        RecognizeInvoicesOptions finalRecognizeInvoicesOptions = Utility.getRecognizeInvoicesOptions(recognizeInvoicesOptions);
        boolean isFieldElementsIncluded = finalRecognizeInvoicesOptions.isFieldElementsIncluded();
        FormRecognizerLocale localeInfo = finalRecognizeInvoicesOptions.getLocale();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse = this.analyzersImpl.analyzeInvoiceWithResponse(isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeInvoicesOptions.getPages(), new SourcePath().setSource(invoiceUrl), context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeInvoiceHeaders)analyzeInvoiceWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> {
            try {
                return this.analyzersImpl.getAnalyzeInvoiceResultWithResponse((UUID)resultId, context);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeInvoiceResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), true, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(InputStream invoice, long length) {
        return this.beginRecognizeInvoices(invoice, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(InputStream invoice, long length, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        return this.beginRecognizeInvoicesInternal(invoice, length, recognizeInvoicesOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesInternal(InputStream businessCard, long length, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        if (businessCard == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'businessCard' is required and cannot be null."));
        }
        RecognizeInvoicesOptions finalInvoiceOptions = Utility.getRecognizeInvoicesOptions(recognizeInvoicesOptions);
        boolean isFieldElementsIncluded = finalInvoiceOptions.isFieldElementsIncluded();
        FormRecognizerLocale localeInfo = finalInvoiceOptions.getLocale();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse = this.analyzersImpl.analyzeInvoiceWithResponse(finalInvoiceOptions.getContentType() != null ? ContentType.fromString(finalInvoiceOptions.getContentType().toString()) : null, (Boolean)isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalInvoiceOptions.getPages(), BinaryData.fromStream((InputStream)businessCard), (Long)length, context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeInvoiceHeaders)analyzeInvoiceWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> {
            try {
                return this.analyzersImpl.getAnalyzeInvoiceResultWithResponse((UUID)resultId, context);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeInvoiceResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), isFieldElementsIncluded, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl) {
        return this.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        return this.beginRecognizeIdentityDocumentsFromUrlInternal(identityDocumentUrl, recognizeIdentityDocumentOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrlInternal(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        if (identityDocumentUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'identityDocumentUrl' is required and cannot be null."));
        }
        RecognizeIdentityDocumentOptions finalRecognizeInvoicesOptions = Utility.getRecognizeIdentityDocumentOptions(recognizeIdentityDocumentOptions);
        boolean isFieldElementsIncluded = finalRecognizeInvoicesOptions.isFieldElementsIncluded();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeInvoiceWithResponse = this.analyzersImpl.analyzeIdDocumentWithResponse(isFieldElementsIncluded, finalRecognizeInvoicesOptions.getPages(), new SourcePath().setSource(identityDocumentUrl), context);
            return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeIdDocumentHeaders)analyzeInvoiceWithResponse.getDeserializedHeaders()).getOperationLocation())));
        }, this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeIdDocumentResultWithResponse((UUID)resultId, context)), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeIdDocumentResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), true, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(InputStream identityDocument, long length) {
        return this.beginRecognizeIdentityDocuments(identityDocument, length, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(InputStream identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        return this.beginRecognizeIdentityDocumentsInternal(identityDocument, length, recognizeIdentityDocumentOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsInternal(InputStream identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        if (identityDocument == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'identityDocument' is required and cannot be null."));
        }
        RecognizeIdentityDocumentOptions finalRecognizeIdentityDocumentOptions = Utility.getRecognizeIdentityDocumentOptions(recognizeIdentityDocumentOptions);
        boolean isFieldElementsIncluded = finalRecognizeIdentityDocumentOptions.isFieldElementsIncluded();
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse = this.analyzersImpl.analyzeIdDocumentWithResponse(finalRecognizeIdentityDocumentOptions.getContentType() != null ? ContentType.fromString(finalRecognizeIdentityDocumentOptions.getContentType().toString()) : null, (Boolean)isFieldElementsIncluded, finalRecognizeIdentityDocumentOptions.getPages(), BinaryData.fromStream((InputStream)identityDocument), (Long)length, context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeIdDocumentHeaders)analyzeIdDocumentWithResponse.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.pollingOperation(resultId -> {
            try {
                return this.analyzersImpl.getAnalyzeIdDocumentResultWithResponse((UUID)resultId, context);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }), this.getCancellationIsNotSupported(), pollingContext -> {
            String resultId = ((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId();
            try {
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)this.analyzersImpl.getAnalyzeIdDocumentResultWithResponse(UUID.fromString(resultId), context).getValue()).getAnalyzeResult(), isFieldElementsIncluded, null);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        });
    }

    private Function<PollingContext<FormRecognizerOperationResult>, PollResponse<FormRecognizerOperationResult>> pollingOperation(Function<UUID, Response<AnalyzeOperationResult>> pollingFunction) {
        return pollingContext -> {
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            UUID resultUuid = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
            Response p = (Response)pollingFunction.apply(resultUuid);
            return this.processAnalyzeModelResponse((Response<AnalyzeOperationResult>)p, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse);
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, List<RecognizedForm>> fetchingOperation(Function<UUID, Response<AnalyzeOperationResult>> fetchingFunction, boolean isFieldElementsIncluded, String modelId) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                Response modelSimpleResponse = (Response)fetchingFunction.apply(resultUuid);
                return Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, modelId);
            }
            catch (RuntimeException ex) {
                throw LOGGER.logExceptionAsError(ex);
            }
        };
    }

    private PollResponse<FormRecognizerOperationResult> processAnalyzeModelResponse(Response<AnalyzeOperationResult> analyzeOperationResultResponse, PollResponse<FormRecognizerOperationResult> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new FormRecognizerException("Analyze operation failed", ((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getAnalyzeResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return new PollResponse(status, (Object)((FormRecognizerOperationResult)operationResultPollResponse.getValue()));
    }

    private BiFunction<PollingContext<FormRecognizerOperationResult>, PollResponse<FormRecognizerOperationResult>, FormRecognizerOperationResult> getCancellationIsNotSupported() {
        return (pollingContext, activationResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, FormRecognizerOperationResult> analyzeActivationOperation(UUID modelId, String formUrl, FormContentType contentType, BinaryData form, long length, boolean isFieldElementsIncluded, RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions, Context context) {
        return pollingContext -> new FormRecognizerOperationResult(Utility.parseModelId(((CustomModelsAnalyzeDocumentHeaders)this.analyzeDocument(modelId, formUrl, contentType, form, length, isFieldElementsIncluded, finalRecognizeCustomFormsOptions, context).getDeserializedHeaders()).getOperationLocation()));
    }

    private ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocument(UUID modelId, String formUrl, FormContentType contentType, BinaryData form, long length, boolean isFieldElementsIncluded, RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions, Context context) {
        try {
            if (formUrl != null) {
                return this.customModelsImpl.analyzeDocumentWithResponse(modelId, isFieldElementsIncluded, finalRecognizeCustomFormsOptions.getPages(), new SourcePath().setSource(formUrl), context);
            }
            return this.customModelsImpl.analyzeDocumentWithResponse(modelId, contentType != null ? ContentType.fromString(contentType.toString()) : null, (Boolean)isFieldElementsIncluded, finalRecognizeCustomFormsOptions.getPages(), form, (Long)length, context);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }
}

