/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis;

import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.implementation.DocumentClassifiersImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.DocumentModelsImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ClassifyDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifiersClassifyDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Constants;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Transforms;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Utility;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeDocumentOptions;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeResult;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentAnalysisFeature;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

@ServiceClient(builder=DocumentAnalysisClientBuilder.class)
public final class DocumentAnalysisClient {
    private static final ClientLogger LOGGER = new ClientLogger(DocumentAnalysisClient.class);
    private final DocumentModelsImpl documentModelsImpl;
    private final DocumentClassifiersImpl documentClassifiersImpl;

    DocumentAnalysisClient(FormRecognizerClientImpl formRecognizerClientImpl) {
        this.documentModelsImpl = formRecognizerClientImpl.getDocumentModels();
        this.documentClassifiersImpl = formRecognizerClientImpl.getDocumentClassifiers();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl) {
        return this.beginAnalyzeDocumentFromUrl(modelId, documentUrl, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrl(String modelId, String documentUrl, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        return this.beginAnalyzeDocumentFromUrlSync(documentUrl, modelId, analyzeDocumentOptions, context);
    }

    private SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocumentFromUrlSync(String documentUrl, String modelId, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)documentUrl)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'documentUrl' is required and cannot be null or empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        AnalyzeDocumentOptions finalAnalyzeDocumentOptions = Utility.getAnalyzeDocumentOptions(analyzeDocumentOptions);
        Context finalContext = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.analyzeActivationOperation(modelId, finalAnalyzeDocumentOptions.getPages(), finalAnalyzeDocumentOptions.getLocale(), finalAnalyzeDocumentOptions.getDocumentAnalysisFeatures(), null, documentUrl, finalContext).apply((PollingContext<OperationResult>)cxt)), this.pollingOperation(modelId, finalContext), this.getCancellationIsNotSupported(), this.fetchingOperation(modelId, finalContext));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document) {
        return this.beginAnalyzeDocument(modelId, document, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginAnalyzeDocument(String modelId, BinaryData document, AnalyzeDocumentOptions analyzeDocumentOptions, Context context) {
        Objects.requireNonNull(document, "'document' is required and cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        if (document.getLength() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'document length' is required and cannot be null"));
        }
        AnalyzeDocumentOptions finalAnalyzeDocumentOptions = Utility.getAnalyzeDocumentOptions(analyzeDocumentOptions);
        Context finalContext = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.analyzeActivationOperation(modelId, finalAnalyzeDocumentOptions.getPages(), finalAnalyzeDocumentOptions.getLocale(), finalAnalyzeDocumentOptions.getDocumentAnalysisFeatures(), document, null, finalContext).apply((PollingContext<OperationResult>)cxt)), this.pollingOperation(modelId, finalContext), this.getCancellationIsNotSupported(), this.fetchingOperation(modelId, finalContext));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginClassifyDocumentFromUrl(String classifierId, String documentUrl) {
        return this.beginClassifyDocumentFromUrl(documentUrl, classifierId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginClassifyDocument(String classifierId, BinaryData document) {
        return this.beginClassifyDocument(classifierId, document, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginClassifyDocumentFromUrl(String classifierId, String documentUrl, Context context) {
        return this.beginClassifyDocumentFromUrlSync(documentUrl, classifierId, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<OperationResult, AnalyzeResult> beginClassifyDocument(String classifierId, BinaryData document, Context context) {
        Objects.requireNonNull(document, "'document' is required and cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)classifierId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'classifierId' is required and cannot be null or empty"));
        }
        if (document.getLength() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'document length' is required and cannot be null"));
        }
        Context finalContext = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.classifyActivationOperation(classifierId, document, null, finalContext).apply((PollingContext<OperationResult>)cxt)), this.pollingClassifierOperation(classifierId, finalContext), this.getCancellationIsNotSupported(), this.fetchingClassifierOperation(classifierId, finalContext));
    }

    private SyncPoller<OperationResult, AnalyzeResult> beginClassifyDocumentFromUrlSync(String documentUrl, String classifierId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)documentUrl)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'documentUrl' is required and cannot be null or empty"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)classifierId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'classifierId' is required and cannot be null or empty"));
        }
        Context finalContext = Utility.enableSyncRestProxy(Utility.getTracingContext(context));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.classifyActivationOperation(classifierId, null, documentUrl, finalContext).apply((PollingContext<OperationResult>)cxt)), this.pollingClassifierOperation(classifierId, finalContext), this.getCancellationIsNotSupported(), this.fetchingClassifierOperation(classifierId, finalContext));
    }

    private Function<PollingContext<OperationResult>, OperationResult> analyzeActivationOperation(String modelId, List<String> pages, String locale, List<DocumentAnalysisFeature> features, BinaryData document, String documentUrl, Context context) {
        return pollingContext -> Transforms.toDocumentOperationResult(((DocumentModelsAnalyzeDocumentHeaders)this.analyzeDocument(modelId, CoreUtils.isNullOrEmpty((Collection)pages) ? null : String.join((CharSequence)",", pages), locale, features, document, documentUrl, context).getDeserializedHeaders()).getOperationLocation());
    }

    private Function<PollingContext<OperationResult>, OperationResult> classifyActivationOperation(String classifierId, BinaryData document, String documentUrl, Context context) {
        try {
            ResponseBase<DocumentClassifiersClassifyDocumentHeaders, Void> response = documentUrl != null ? this.documentClassifiersImpl.classifyDocumentWithResponse(classifierId, StringIndexType.UTF16CODE_UNIT, new ClassifyDocumentRequest().setUrlSource(documentUrl), context) : this.documentClassifiersImpl.classifyDocumentWithResponse(classifierId, null, StringIndexType.UTF16CODE_UNIT, document, document.getLength(), context);
            return pollingContext -> Transforms.toDocumentOperationResult(((DocumentClassifiersClassifyDocumentHeaders)response.getDeserializedHeaders()).getOperationLocation());
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    private ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocument(String modelId, String pages, String locale, List<DocumentAnalysisFeature> features, BinaryData document, String documentUrl, Context context) {
        try {
            if (documentUrl == null) {
                return this.documentModelsImpl.analyzeDocumentWithResponse(modelId, null, pages, locale, StringIndexType.UTF16CODE_UNIT, features, document, document.getLength(), context);
            }
            return this.documentModelsImpl.analyzeDocumentWithResponse(modelId, pages, locale, StringIndexType.UTF16CODE_UNIT, features, new AnalyzeDocumentRequest().setUrlSource(documentUrl), context);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
        }
    }

    private BiFunction<PollingContext<OperationResult>, PollResponse<OperationResult>, OperationResult> getCancellationIsNotSupported() {
        return (pollingContext, activationResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        };
    }

    private Function<PollingContext<OperationResult>, PollResponse<OperationResult>> pollingOperation(String modelId, Context finalContext) {
        return pollingContext -> {
            Response<AnalyzeResultOperation> modelResponse;
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            String resultId = ((OperationResult)operationResultPollResponse.getValue()).getOperationId();
            try {
                modelResponse = this.documentModelsImpl.getAnalyzeResultWithResponse(modelId, resultId, finalContext);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
            return this.processAnalyzeModelResponse(modelResponse, (PollResponse<OperationResult>)operationResultPollResponse);
        };
    }

    private PollResponse<OperationResult> processAnalyzeModelResponse(Response<AnalyzeResultOperation> analyzeResultOperationResponse, PollResponse<OperationResult> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((AnalyzeResultOperation)analyzeResultOperationResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.mapResponseErrorToHttpResponseException(((AnalyzeResultOperation)analyzeResultOperationResponse.getValue()).getError())));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((AnalyzeResultOperation)analyzeResultOperationResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return new PollResponse(status, (Object)((OperationResult)operationResultPollResponse.getValue()));
    }

    private Function<PollingContext<OperationResult>, AnalyzeResult> fetchingOperation(String modelId, Context finalContext) {
        return pollingContext -> {
            String resultId = ((OperationResult)pollingContext.getLatestResponse().getValue()).getOperationId();
            try {
                return Transforms.toAnalyzeResultOperation(((AnalyzeResultOperation)this.documentModelsImpl.getAnalyzeResultWithResponse(modelId, resultId, finalContext).getValue()).getAnalyzeResult());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }

    private Function<PollingContext<OperationResult>, PollResponse<OperationResult>> pollingClassifierOperation(String classifierId, Context finalContext) {
        return pollingContext -> {
            Response<AnalyzeResultOperation> analyzeResultOperationResponse;
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            String resultId = ((OperationResult)operationResultPollResponse.getValue()).getOperationId();
            try {
                analyzeResultOperationResponse = this.documentClassifiersImpl.getClassifyResultWithResponse(classifierId, resultId, finalContext);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
            return this.processAnalyzeModelResponse(analyzeResultOperationResponse, (PollResponse<OperationResult>)operationResultPollResponse);
        };
    }

    private Function<PollingContext<OperationResult>, AnalyzeResult> fetchingClassifierOperation(String classifierId, Context finalContext) {
        return pollingContext -> {
            String resultId = ((OperationResult)pollingContext.getLatestResponse().getValue()).getOperationId();
            try {
                return Transforms.toAnalyzeResultOperation(((AnalyzeResultOperation)this.documentClassifiersImpl.getClassifyResultWithResponse(classifierId, resultId, finalContext).getValue()).getAnalyzeResult());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)Transforms.getHttpResponseException(ex)));
            }
        };
    }
}

