/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResult;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperationStatus;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.Error;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public final class AnalyzeResultOperation
implements JsonSerializable<AnalyzeResultOperation> {
    private final AnalyzeResultOperationStatus status;
    private final OffsetDateTime createdDateTime;
    private final OffsetDateTime lastUpdatedDateTime;
    private Error error;
    private AnalyzeResult analyzeResult;

    public AnalyzeResultOperation(AnalyzeResultOperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    public AnalyzeResultOperationStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Error getError() {
        return this.error;
    }

    public AnalyzeResultOperation setError(Error error) {
        this.error = error;
        return this;
    }

    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }

    public AnalyzeResultOperation setAnalyzeResult(AnalyzeResult analyzeResult) {
        this.analyzeResult = analyzeResult;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("analyzeResult", (JsonSerializable)this.analyzeResult);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeResultOperation fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeResultOperation)jsonReader.readObject(reader -> {
            boolean statusFound = false;
            AnalyzeResultOperationStatus status = null;
            boolean createdDateTimeFound = false;
            OffsetDateTime createdDateTime = null;
            boolean lastUpdatedDateTimeFound = false;
            OffsetDateTime lastUpdatedDateTime = null;
            Error error = null;
            AnalyzeResult analyzeResult = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = AnalyzeResultOperationStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    createdDateTimeFound = true;
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    lastUpdatedDateTimeFound = true;
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                if ("analyzeResult".equals(fieldName)) {
                    analyzeResult = AnalyzeResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (statusFound && createdDateTimeFound && lastUpdatedDateTimeFound) {
                AnalyzeResultOperation deserializedAnalyzeResultOperation = new AnalyzeResultOperation(status, createdDateTime, lastUpdatedDateTime);
                deserializedAnalyzeResultOperation.error = error;
                deserializedAnalyzeResultOperation.analyzeResult = analyzeResult;
                return deserializedAnalyzeResultOperation;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!createdDateTimeFound) {
                missingProperties.add("createdDateTime");
            }
            if (!lastUpdatedDateTimeFound) {
                missingProperties.add("lastUpdatedDateTime");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

