/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ClassifierDocumentTypeDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class BuildDocumentClassifierRequest
implements JsonSerializable<BuildDocumentClassifierRequest> {
    private final String classifierId;
    private String description;
    private final Map<String, ClassifierDocumentTypeDetails> docTypes;

    public BuildDocumentClassifierRequest(String classifierId, Map<String, ClassifierDocumentTypeDetails> docTypes) {
        this.classifierId = classifierId;
        this.docTypes = docTypes;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public String getDescription() {
        return this.description;
    }

    public BuildDocumentClassifierRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, ClassifierDocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeMapField("docTypes", this.docTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static BuildDocumentClassifierRequest fromJson(JsonReader jsonReader) throws IOException {
        return (BuildDocumentClassifierRequest)jsonReader.readObject(reader -> {
            boolean classifierIdFound = false;
            String classifierId = null;
            boolean docTypesFound = false;
            Map docTypes = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    classifierIdFound = true;
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    docTypes = reader.readMap(reader1 -> ClassifierDocumentTypeDetails.fromJson(reader1));
                    docTypesFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (classifierIdFound && docTypesFound) {
                BuildDocumentClassifierRequest deserializedBuildDocumentClassifierRequest = new BuildDocumentClassifierRequest(classifierId, docTypes);
                deserializedBuildDocumentClassifierRequest.description = description;
                return deserializedBuildDocumentClassifierRequest;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!classifierIdFound) {
                missingProperties.add("classifierId");
            }
            if (!docTypesFound) {
                missingProperties.add("docTypes");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

