/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;

public final class CopyAuthorization
implements JsonSerializable<CopyAuthorization> {
    private final String targetResourceId;
    private final String targetResourceRegion;
    private final String targetModelId;
    private final String targetModelLocation;
    private final String accessToken;
    private final OffsetDateTime expirationDateTime;

    public CopyAuthorization(String targetResourceId, String targetResourceRegion, String targetModelId, String targetModelLocation, String accessToken, OffsetDateTime expirationDateTime) {
        this.targetResourceId = targetResourceId;
        this.targetResourceRegion = targetResourceRegion;
        this.targetModelId = targetModelId;
        this.targetModelLocation = targetModelLocation;
        this.accessToken = accessToken;
        this.expirationDateTime = expirationDateTime;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    public String getTargetModelId() {
        return this.targetModelId;
    }

    public String getTargetModelLocation() {
        return this.targetModelLocation;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeStringField("targetModelId", this.targetModelId);
        jsonWriter.writeStringField("targetModelLocation", this.targetModelLocation);
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        return jsonWriter.writeEndObject();
    }

    public static CopyAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (CopyAuthorization)jsonReader.readObject(reader -> {
            boolean targetResourceIdFound = false;
            String targetResourceId = null;
            boolean targetResourceRegionFound = false;
            String targetResourceRegion = null;
            boolean targetModelIdFound = false;
            String targetModelId = null;
            boolean targetModelLocationFound = false;
            String targetModelLocation = null;
            boolean accessTokenFound = false;
            String accessToken = null;
            boolean expirationDateTimeFound = false;
            OffsetDateTime expirationDateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    targetResourceId = reader.getString();
                    targetResourceIdFound = true;
                    continue;
                }
                if ("targetResourceRegion".equals(fieldName)) {
                    targetResourceRegion = reader.getString();
                    targetResourceRegionFound = true;
                    continue;
                }
                if ("targetModelId".equals(fieldName)) {
                    targetModelId = reader.getString();
                    targetModelIdFound = true;
                    continue;
                }
                if ("targetModelLocation".equals(fieldName)) {
                    targetModelLocation = reader.getString();
                    targetModelLocationFound = true;
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    accessToken = reader.getString();
                    accessTokenFound = true;
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    expirationDateTimeFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (targetResourceIdFound && targetResourceRegionFound && targetModelIdFound && targetModelLocationFound && accessTokenFound && expirationDateTimeFound) {
                return new CopyAuthorization(targetResourceId, targetResourceRegion, targetModelId, targetModelLocation, accessToken, expirationDateTime);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!targetResourceIdFound) {
                missingProperties.add("targetResourceId");
            }
            if (!targetResourceRegionFound) {
                missingProperties.add("targetResourceRegion");
            }
            if (!targetModelIdFound) {
                missingProperties.add("targetModelId");
            }
            if (!targetModelLocationFound) {
                missingProperties.add("targetModelLocation");
            }
            if (!accessTokenFound) {
                missingProperties.add("accessToken");
            }
            if (!expirationDateTimeFound) {
                missingProperties.add("expirationDateTime");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

