/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ClassifierDocumentTypeDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;

public final class DocumentClassifierDetails
implements JsonSerializable<DocumentClassifierDetails> {
    private final String classifierId;
    private String description;
    private final OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private final String apiVersion;
    private final Map<String, ClassifierDocumentTypeDetails> docTypes;

    public DocumentClassifierDetails(String classifierId, OffsetDateTime createdDateTime, String apiVersion, Map<String, ClassifierDocumentTypeDetails> docTypes) {
        this.classifierId = classifierId;
        this.createdDateTime = createdDateTime;
        this.apiVersion = apiVersion;
        this.docTypes = docTypes;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentClassifierDetails setDescription(String description) {
        this.description = description;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public DocumentClassifierDetails setExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, ClassifierDocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("docTypes", this.docTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        return jsonWriter.writeEndObject();
    }

    public static DocumentClassifierDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentClassifierDetails)jsonReader.readObject(reader -> {
            boolean classifierIdFound = false;
            String classifierId = null;
            boolean createdDateTimeFound = false;
            OffsetDateTime createdDateTime = null;
            boolean apiVersionFound = false;
            String apiVersion = null;
            boolean docTypesFound = false;
            Map docTypes = null;
            String description = null;
            OffsetDateTime expirationDateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    classifierIdFound = true;
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    createdDateTimeFound = true;
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    apiVersionFound = true;
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    docTypes = reader.readMap(reader1 -> ClassifierDocumentTypeDetails.fromJson(reader1));
                    docTypesFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (classifierIdFound && createdDateTimeFound && apiVersionFound && docTypesFound) {
                DocumentClassifierDetails deserializedDocumentClassifierDetails = new DocumentClassifierDetails(classifierId, createdDateTime, apiVersion, docTypes);
                deserializedDocumentClassifierDetails.description = description;
                deserializedDocumentClassifierDetails.expirationDateTime = expirationDateTime;
                return deserializedDocumentClassifierDetails;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!classifierIdFound) {
                missingProperties.add("classifierId");
            }
            if (!createdDateTimeFound) {
                missingProperties.add("createdDateTime");
            }
            if (!apiVersionFound) {
                missingProperties.add("apiVersion");
            }
            if (!docTypesFound) {
                missingProperties.add("docTypes");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

