/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentLine
implements JsonSerializable<DocumentLine> {
    private final String content;
    private List<Float> polygon;
    private final List<DocumentSpan> spans;

    public DocumentLine(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    public String getContent() {
        return this.content;
    }

    public List<Float> getPolygon() {
        return this.polygon;
    }

    public DocumentLine setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentLine fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentLine)jsonReader.readObject(reader -> {
            boolean contentFound = false;
            String content = null;
            boolean spansFound = false;
            List spans = null;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    contentFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                reader.skipChildren();
            }
            if (contentFound && spansFound) {
                DocumentLine deserializedDocumentLine = new DocumentLine(content, spans);
                deserializedDocumentLine.polygon = polygon;
                return deserializedDocumentLine;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

