/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.Error;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;

public final class DocumentModelComposeOperationDetails
extends OperationDetails {
    private DocumentModelDetails result;

    public DocumentModelComposeOperationDetails(String operationId, OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime, String resourceLocation) {
        super(operationId, status, createdDateTime, lastUpdatedDateTime, resourceLocation);
    }

    public DocumentModelDetails getResult() {
        return this.result;
    }

    public DocumentModelComposeOperationDetails setResult(DocumentModelDetails result) {
        this.result = result;
        return this;
    }

    @Override
    public DocumentModelComposeOperationDetails setPercentCompleted(Integer percentCompleted) {
        super.setPercentCompleted(percentCompleted);
        return this;
    }

    @Override
    public DocumentModelComposeOperationDetails setApiVersion(String apiVersion) {
        super.setApiVersion(apiVersion);
        return this;
    }

    @Override
    public DocumentModelComposeOperationDetails setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public DocumentModelComposeOperationDetails setError(Error error) {
        super.setError(error);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", "documentModelCompose");
        jsonWriter.writeStringField("operationId", this.getOperationId());
        jsonWriter.writeStringField("status", this.getStatus() == null ? null : this.getStatus().toString());
        jsonWriter.writeStringField("createdDateTime", this.getCreatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreatedDateTime()));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.getLastUpdatedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getLastUpdatedDateTime()));
        jsonWriter.writeStringField("resourceLocation", this.getResourceLocation());
        jsonWriter.writeNumberField("percentCompleted", (Number)this.getPercentCompleted());
        jsonWriter.writeStringField("apiVersion", this.getApiVersion());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.getError());
        jsonWriter.writeJsonField("result", (JsonSerializable)this.result);
        return jsonWriter.writeEndObject();
    }

    public static DocumentModelComposeOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentModelComposeOperationDetails)jsonReader.readObject(reader -> {
            boolean operationIdFound = false;
            String operationId = null;
            boolean statusFound = false;
            OperationStatus status = null;
            boolean createdDateTimeFound = false;
            OffsetDateTime createdDateTime = null;
            boolean lastUpdatedDateTimeFound = false;
            OffsetDateTime lastUpdatedDateTime = null;
            boolean resourceLocationFound = false;
            String resourceLocation = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            Error error = null;
            DocumentModelDetails result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("documentModelCompose".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'documentModelCompose'. The found 'kind' was '" + kind + "'.");
                }
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    operationIdFound = true;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    createdDateTimeFound = true;
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    lastUpdatedDateTimeFound = true;
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    resourceLocationFound = true;
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = DocumentModelDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (operationIdFound && statusFound && createdDateTimeFound && lastUpdatedDateTimeFound && resourceLocationFound) {
                DocumentModelComposeOperationDetails deserializedDocumentModelComposeOperationDetails = new DocumentModelComposeOperationDetails(operationId, status, createdDateTime, lastUpdatedDateTime, resourceLocation);
                deserializedDocumentModelComposeOperationDetails.setPercentCompleted(percentCompleted);
                deserializedDocumentModelComposeOperationDetails.setApiVersion(apiVersion);
                deserializedDocumentModelComposeOperationDetails.setTags(tags);
                deserializedDocumentModelComposeOperationDetails.setError(error);
                deserializedDocumentModelComposeOperationDetails.result = result;
                return deserializedDocumentModelComposeOperationDetails;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!operationIdFound) {
                missingProperties.add("operationId");
            }
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!createdDateTimeFound) {
                missingProperties.add("createdDateTime");
            }
            if (!lastUpdatedDateTimeFound) {
                missingProperties.add("lastUpdatedDateTime");
            }
            if (!resourceLocationFound) {
                missingProperties.add("resourceLocation");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

