/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.models.FontStyle;
import com.azure.ai.formrecognizer.documentanalysis.models.FontWeight;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentStyle
implements JsonSerializable<DocumentStyle> {
    private Boolean isHandwritten;
    private String similarFontFamily;
    private FontStyle fontStyle;
    private FontWeight fontWeight;
    private String color;
    private String backgroundColor;
    private final List<DocumentSpan> spans;
    private final float confidence;

    public DocumentStyle(List<DocumentSpan> spans, float confidence) {
        this.spans = spans;
        this.confidence = confidence;
    }

    public Boolean isHandwritten() {
        return this.isHandwritten;
    }

    public DocumentStyle setIsHandwritten(Boolean isHandwritten) {
        this.isHandwritten = isHandwritten;
        return this;
    }

    public String getSimilarFontFamily() {
        return this.similarFontFamily;
    }

    public DocumentStyle setSimilarFontFamily(String similarFontFamily) {
        this.similarFontFamily = similarFontFamily;
        return this;
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public DocumentStyle setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    public FontWeight getFontWeight() {
        return this.fontWeight;
    }

    public DocumentStyle setFontWeight(FontWeight fontWeight) {
        this.fontWeight = fontWeight;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public DocumentStyle setColor(String color) {
        this.color = color;
        return this;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public DocumentStyle setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeBooleanField("isHandwritten", this.isHandwritten);
        jsonWriter.writeStringField("similarFontFamily", this.similarFontFamily);
        jsonWriter.writeStringField("fontStyle", this.fontStyle == null ? null : this.fontStyle.toString());
        jsonWriter.writeStringField("fontWeight", this.fontWeight == null ? null : this.fontWeight.toString());
        jsonWriter.writeStringField("color", this.color);
        jsonWriter.writeStringField("backgroundColor", this.backgroundColor);
        return jsonWriter.writeEndObject();
    }

    public static DocumentStyle fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentStyle)jsonReader.readObject(reader -> {
            boolean spansFound = false;
            List spans = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            Boolean isHandwritten = null;
            String similarFontFamily = null;
            FontStyle fontStyle = null;
            FontWeight fontWeight = null;
            String color = null;
            String backgroundColor = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                if ("isHandwritten".equals(fieldName)) {
                    isHandwritten = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("similarFontFamily".equals(fieldName)) {
                    similarFontFamily = reader.getString();
                    continue;
                }
                if ("fontStyle".equals(fieldName)) {
                    fontStyle = FontStyle.fromString(reader.getString());
                    continue;
                }
                if ("fontWeight".equals(fieldName)) {
                    fontWeight = FontWeight.fromString(reader.getString());
                    continue;
                }
                if ("color".equals(fieldName)) {
                    color = reader.getString();
                    continue;
                }
                if ("backgroundColor".equals(fieldName)) {
                    backgroundColor = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (spansFound && confidenceFound) {
                DocumentStyle deserializedDocumentStyle = new DocumentStyle(spans, confidence);
                deserializedDocumentStyle.isHandwritten = isHandwritten;
                deserializedDocumentStyle.similarFontFamily = similarFontFamily;
                deserializedDocumentStyle.fontStyle = fontStyle;
                deserializedDocumentStyle.fontWeight = fontWeight;
                deserializedDocumentStyle.color = color;
                deserializedDocumentStyle.backgroundColor = backgroundColor;
                return deserializedDocumentStyle;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!spansFound) {
                missingProperties.add("spans");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

