/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentTableCell;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentTable
implements JsonSerializable<DocumentTable> {
    private final int rowCount;
    private final int columnCount;
    private final List<DocumentTableCell> cells;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;

    public DocumentTable(int rowCount, int columnCount, List<DocumentTableCell> cells, List<DocumentSpan> spans) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = cells;
        this.spans = spans;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<DocumentTableCell> getCells() {
        return this.cells;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public DocumentTable setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowCount", this.rowCount);
        jsonWriter.writeIntField("columnCount", this.columnCount);
        jsonWriter.writeArrayField("cells", this.cells, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentTable fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentTable)jsonReader.readObject(reader -> {
            boolean rowCountFound = false;
            int rowCount = 0;
            boolean columnCountFound = false;
            int columnCount = 0;
            boolean cellsFound = false;
            List cells = null;
            boolean spansFound = false;
            List spans = null;
            List boundingRegions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rowCount".equals(fieldName)) {
                    rowCount = reader.getInt();
                    rowCountFound = true;
                    continue;
                }
                if ("columnCount".equals(fieldName)) {
                    columnCount = reader.getInt();
                    columnCountFound = true;
                    continue;
                }
                if ("cells".equals(fieldName)) {
                    cells = reader.readArray(reader1 -> DocumentTableCell.fromJson(reader1));
                    cellsFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (rowCountFound && columnCountFound && cellsFound && spansFound) {
                DocumentTable deserializedDocumentTable = new DocumentTable(rowCount, columnCount, cells, spans);
                deserializedDocumentTable.boundingRegions = boundingRegions;
                return deserializedDocumentTable;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!rowCountFound) {
                missingProperties.add("rowCount");
            }
            if (!columnCountFound) {
                missingProperties.add("columnCount");
            }
            if (!cellsFound) {
                missingProperties.add("cells");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

