/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentWord
implements JsonSerializable<DocumentWord> {
    private final String content;
    private List<Float> polygon;
    private final DocumentSpan span;
    private final float confidence;

    public DocumentWord(String content, DocumentSpan span, float confidence) {
        this.content = content;
        this.span = span;
        this.confidence = confidence;
    }

    public String getContent() {
        return this.content;
    }

    public List<Float> getPolygon() {
        return this.polygon;
    }

    public DocumentWord setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    public DocumentSpan getSpan() {
        return this.span;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeJsonField("span", (JsonSerializable)this.span);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentWord fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentWord)jsonReader.readObject(reader -> {
            boolean contentFound = false;
            String content = null;
            boolean spanFound = false;
            DocumentSpan span = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    contentFound = true;
                    continue;
                }
                if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                    spanFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                reader.skipChildren();
            }
            if (contentFound && spanFound && confidenceFound) {
                DocumentWord deserializedDocumentWord = new DocumentWord(content, span, confidence);
                deserializedDocumentWord.polygon = polygon;
                return deserializedDocumentWord;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!spanFound) {
                missingProperties.add("span");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

