/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.ComposeRequest;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyOperationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyRequest;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAuthorizeModelCopyHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsComposeHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsCopyHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsTrainHeaders;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CustomModelsImpl {
    private final CustomModelsService service;
    private final FormRecognizerClientImpl client;

    CustomModelsImpl(FormRecognizerClientImpl client) {
        this.service = (CustomModelsService)RestProxy.create(CustomModelsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsTrainHeaders, Void>> trainWithResponseAsync(TrainRequest trainRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.train(this.client.getEndpoint(), this.client.getApiVersion(), trainRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsTrainHeaders, Void>> trainWithResponseAsync(TrainRequest trainRequest, Context context) {
        String accept = "application/json";
        return this.service.train(this.client.getEndpoint(), this.client.getApiVersion(), trainRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> trainAsync(TrainRequest trainRequest) {
        return this.trainWithResponseAsync(trainRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> trainAsync(TrainRequest trainRequest, Context context) {
        return this.trainWithResponseAsync(trainRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsTrainHeaders, Void> trainWithResponse(TrainRequest trainRequest, Context context) {
        return (ResponseBase)this.trainWithResponseAsync(trainRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void train(TrainRequest trainRequest) {
        this.trainWithResponse(trainRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Model>> getWithResponseAsync(UUID modelId, Boolean includeKeys) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeKeys, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Model>> getWithResponseAsync(UUID modelId, Boolean includeKeys, Context context) {
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeKeys, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Model> getAsync(UUID modelId, Boolean includeKeys) {
        return this.getWithResponseAsync(modelId, includeKeys).flatMap(res -> Mono.justOrEmpty((Object)((Model)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Model> getAsync(UUID modelId, Boolean includeKeys, Context context) {
        return this.getWithResponseAsync(modelId, includeKeys, context).flatMap(res -> Mono.justOrEmpty((Object)((Model)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Model> getWithResponse(UUID modelId, Boolean includeKeys, Context context) {
        return (Response)this.getWithResponseAsync(modelId, includeKeys, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Model get(UUID modelId, Boolean includeKeys) {
        return (Model)this.getWithResponse(modelId, includeKeys, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(UUID modelId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), modelId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(UUID modelId, Context context) {
        String accept = "application/json";
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), modelId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(UUID modelId) {
        return this.deleteWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(UUID modelId, Context context) {
        return this.deleteWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(UUID modelId, Context context) {
        return (Response)this.deleteWithResponseAsync(modelId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(UUID modelId) {
        this.deleteWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeDocument(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeDocumentWithResponse(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        return this.analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return this.analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeDocument(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        this.analyzeDocumentWithResponse(modelId, contentType, includeTextDetails, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeTextDetails, pagesConverted, fileStream, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeTextDetails, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return this.analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return (ResponseBase)this.analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeDocument(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        this.analyzeDocumentWithResponse(modelId, includeTextDetails, pages, fileStream, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeResultWithResponseAsync(UUID modelId, UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAnalyzeResult(this.client.getEndpoint(), this.client.getApiVersion(), modelId, resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeResultWithResponseAsync(UUID modelId, UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeResult(this.client.getEndpoint(), this.client.getApiVersion(), modelId, resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeResultAsync(UUID modelId, UUID resultId) {
        return this.getAnalyzeResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeResultAsync(UUID modelId, UUID resultId, Context context) {
        return this.getAnalyzeResultWithResponseAsync(modelId, resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeResultWithResponse(UUID modelId, UUID resultId, Context context) {
        return (Response)this.getAnalyzeResultWithResponseAsync(modelId, resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeResult(UUID modelId, UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsCopyHeaders, Void>> copyWithResponseAsync(UUID modelId, CopyRequest copyRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.copy(this.client.getEndpoint(), this.client.getApiVersion(), modelId, copyRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsCopyHeaders, Void>> copyWithResponseAsync(UUID modelId, CopyRequest copyRequest, Context context) {
        String accept = "application/json";
        return this.service.copy(this.client.getEndpoint(), this.client.getApiVersion(), modelId, copyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> copyAsync(UUID modelId, CopyRequest copyRequest) {
        return this.copyWithResponseAsync(modelId, copyRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> copyAsync(UUID modelId, CopyRequest copyRequest, Context context) {
        return this.copyWithResponseAsync(modelId, copyRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsCopyHeaders, Void> copyWithResponse(UUID modelId, CopyRequest copyRequest, Context context) {
        return (ResponseBase)this.copyWithResponseAsync(modelId, copyRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void copy(UUID modelId, CopyRequest copyRequest) {
        this.copyWithResponse(modelId, copyRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCopyResultWithResponseAsync(UUID modelId, UUID resultId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCopyResult(this.client.getEndpoint(), this.client.getApiVersion(), modelId, resultId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCopyResultWithResponseAsync(UUID modelId, UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getCopyResult(this.client.getEndpoint(), this.client.getApiVersion(), modelId, resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCopyResultAsync(UUID modelId, UUID resultId) {
        return this.getCopyResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty((Object)((CopyOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCopyResultAsync(UUID modelId, UUID resultId, Context context) {
        return this.getCopyResultWithResponseAsync(modelId, resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((CopyOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyOperationResult> getCopyResultWithResponse(UUID modelId, UUID resultId, Context context) {
        return (Response)this.getCopyResultWithResponseAsync(modelId, resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyOperationResult getCopyResult(UUID modelId, UUID resultId) {
        return (CopyOperationResult)this.getCopyResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>> authorizeModelCopyWithResponseAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.authorizeModelCopy(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>> authorizeModelCopyWithResponseAsync(Context context) {
        String accept = "application/json";
        return this.service.authorizeModelCopy(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> authorizeModelCopyAsync() {
        return this.authorizeModelCopyWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((CopyAuthorizationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> authorizeModelCopyAsync(Context context) {
        return this.authorizeModelCopyWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((CopyAuthorizationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult> authorizeModelCopyWithResponse(Context context) {
        return (ResponseBase)this.authorizeModelCopyWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorizationResult authorizeModelCopy() {
        return (CopyAuthorizationResult)this.authorizeModelCopyWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsComposeHeaders, Void>> composeWithResponseAsync(ComposeRequest composeRequest) {
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.compose(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, "application/json, text/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsComposeHeaders, Void>> composeWithResponseAsync(ComposeRequest composeRequest, Context context) {
        String accept = "application/json, text/json";
        return this.service.compose(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, "application/json, text/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> composeAsync(ComposeRequest composeRequest) {
        return this.composeWithResponseAsync(composeRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> composeAsync(ComposeRequest composeRequest, Context context) {
        return this.composeWithResponseAsync(composeRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<CustomModelsComposeHeaders, Void> composeWithResponse(ComposeRequest composeRequest, Context context) {
        return (ResponseBase)this.composeWithResponseAsync(composeRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void compose(ComposeRequest composeRequest) {
        this.composeWithResponse(composeRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listSinglePageAsync() {
        String op = "full";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "full", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listSinglePageAsync(Context context) {
        String op = "full";
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "full", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listSinglePage() {
        return (PagedResponse)this.listSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listSinglePage(Context context) {
        return (PagedResponse)this.listSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> list() {
        return new PagedIterable(this.listAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Models>> getSummaryWithResponseAsync() {
        String op = "summary";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSummary(this.client.getEndpoint(), this.client.getApiVersion(), "summary", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Models>> getSummaryWithResponseAsync(Context context) {
        String op = "summary";
        String accept = "application/json";
        return this.service.getSummary(this.client.getEndpoint(), this.client.getApiVersion(), "summary", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Models> getSummaryAsync() {
        return this.getSummaryWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((Models)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Models> getSummaryAsync(Context context) {
        return this.getSummaryWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((Models)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Models> getSummaryWithResponse(Context context) {
        return (Response)this.getSummaryWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Models getSummary() {
        return (Models)this.getSummaryWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listNext(nextLink, this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listNextSinglePage(String nextLink) {
        return (PagedResponse)this.listNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.listNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}/formrecognizer/{ApiVersion}")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface CustomModelsService {
        @Post(value="/custom/models")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsTrainHeaders, Void>> train(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @BodyParam(value="application/json") TrainRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/custom/models/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Model>> get(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeKeys") Boolean var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/custom/models/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeTextDetails") Boolean var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeTextDetails") Boolean var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @QueryParam(value="includeTextDetails") Boolean var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/custom/models/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @PathParam(value="resultId") UUID var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/custom/models/{modelId}/copy")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsCopyHeaders, Void>> copy(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @BodyParam(value="application/json") CopyRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/custom/models/{modelId}/copyResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<CopyOperationResult>> getCopyResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="modelId") UUID var3, @PathParam(value="resultId") UUID var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/custom/models/copyAuthorization")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>> authorizeModelCopy(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/custom/models/compose")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<CustomModelsComposeHeaders, Void>> compose(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @BodyParam(value="application/json") ComposeRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/custom/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Models>> list(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="op") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/custom/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Models>> getSummary(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="op") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Models>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HostParam(value="ApiVersion") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

