/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeResult;
import com.azure.ai.formrecognizer.implementation.models.OperationStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AnalyzeOperationResult
implements JsonSerializable<AnalyzeOperationResult> {
    private OperationStatus status;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime lastUpdatedDateTime;
    private AnalyzeResult analyzeResult;

    public OperationStatus getStatus() {
        return this.status;
    }

    public AnalyzeOperationResult setStatus(OperationStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public AnalyzeOperationResult setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public AnalyzeOperationResult setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }

    public AnalyzeOperationResult setAnalyzeResult(AnalyzeResult analyzeResult) {
        this.analyzeResult = analyzeResult;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeJsonField("analyzeResult", (JsonSerializable)this.analyzeResult);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeOperationResult)jsonReader.readObject(reader -> {
            AnalyzeOperationResult deserializedAnalyzeOperationResult = new AnalyzeOperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedAnalyzeOperationResult.status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedAnalyzeOperationResult.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedAnalyzeOperationResult.lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("analyzeResult".equals(fieldName)) {
                    deserializedAnalyzeOperationResult.analyzeResult = AnalyzeResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeOperationResult;
        });
    }
}

