/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.CopyResult;
import com.azure.ai.formrecognizer.implementation.models.OperationStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CopyOperationResult
implements JsonSerializable<CopyOperationResult> {
    private OperationStatus status;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime lastUpdatedDateTime;
    private CopyResult copyResult;

    public OperationStatus getStatus() {
        return this.status;
    }

    public CopyOperationResult setStatus(OperationStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public CopyOperationResult setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public CopyOperationResult setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    public CopyResult getCopyResult() {
        return this.copyResult;
    }

    public CopyOperationResult setCopyResult(CopyResult copyResult) {
        this.copyResult = copyResult;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeJsonField("copyResult", (JsonSerializable)this.copyResult);
        return jsonWriter.writeEndObject();
    }

    public static CopyOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return (CopyOperationResult)jsonReader.readObject(reader -> {
            CopyOperationResult deserializedCopyOperationResult = new CopyOperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedCopyOperationResult.status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedCopyOperationResult.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedCopyOperationResult.lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("copyResult".equals(fieldName)) {
                    deserializedCopyOperationResult.copyResult = CopyResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyOperationResult;
        });
    }
}

