/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CopyRequest
implements JsonSerializable<CopyRequest> {
    private String targetResourceId;
    private String targetResourceRegion;
    private CopyAuthorizationResult copyAuthorization;

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public CopyRequest setTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    public CopyRequest setTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public CopyAuthorizationResult getCopyAuthorization() {
        return this.copyAuthorization;
    }

    public CopyRequest setCopyAuthorization(CopyAuthorizationResult copyAuthorization) {
        this.copyAuthorization = copyAuthorization;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeJsonField("copyAuthorization", (JsonSerializable)this.copyAuthorization);
        return jsonWriter.writeEndObject();
    }

    public static CopyRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CopyRequest)jsonReader.readObject(reader -> {
            CopyRequest deserializedCopyRequest = new CopyRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedCopyRequest.targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceRegion".equals(fieldName)) {
                    deserializedCopyRequest.targetResourceRegion = reader.getString();
                    continue;
                }
                if ("copyAuthorization".equals(fieldName)) {
                    deserializedCopyRequest.copyAuthorization = CopyAuthorizationResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyRequest;
        });
    }
}

