/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.KeysResult;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.TrainResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class Model
implements JsonSerializable<Model> {
    private ModelInfo modelInfo;
    private KeysResult keys;
    private TrainResult trainResult;
    private List<TrainResult> composedTrainResults;

    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public Model setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
        return this;
    }

    public KeysResult getKeys() {
        return this.keys;
    }

    public Model setKeys(KeysResult keys) {
        this.keys = keys;
        return this;
    }

    public TrainResult getTrainResult() {
        return this.trainResult;
    }

    public Model setTrainResult(TrainResult trainResult) {
        this.trainResult = trainResult;
        return this;
    }

    public List<TrainResult> getComposedTrainResults() {
        return this.composedTrainResults;
    }

    public Model setComposedTrainResults(List<TrainResult> composedTrainResults) {
        this.composedTrainResults = composedTrainResults;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("modelInfo", (JsonSerializable)this.modelInfo);
        jsonWriter.writeJsonField("keys", (JsonSerializable)this.keys);
        jsonWriter.writeJsonField("trainResult", (JsonSerializable)this.trainResult);
        jsonWriter.writeArrayField("composedTrainResults", this.composedTrainResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Model fromJson(JsonReader jsonReader) throws IOException {
        return (Model)jsonReader.readObject(reader -> {
            Model deserializedModel = new Model();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelInfo".equals(fieldName)) {
                    deserializedModel.modelInfo = ModelInfo.fromJson(reader);
                    continue;
                }
                if ("keys".equals(fieldName)) {
                    deserializedModel.keys = KeysResult.fromJson(reader);
                    continue;
                }
                if ("trainResult".equals(fieldName)) {
                    deserializedModel.trainResult = TrainResult.fromJson(reader);
                    continue;
                }
                if ("composedTrainResults".equals(fieldName)) {
                    List composedTrainResults;
                    deserializedModel.composedTrainResults = composedTrainResults = reader.readArray(reader1 -> TrainResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModel;
        });
    }
}

