/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ModelsSummary
implements JsonSerializable<ModelsSummary> {
    private int count;
    private int limit;
    private OffsetDateTime lastUpdatedDateTime;

    public int getCount() {
        return this.count;
    }

    public ModelsSummary setCount(int count) {
        this.count = count;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public ModelsSummary setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public ModelsSummary setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("count", this.count);
        jsonWriter.writeIntField("limit", this.limit);
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        return jsonWriter.writeEndObject();
    }

    public static ModelsSummary fromJson(JsonReader jsonReader) throws IOException {
        return (ModelsSummary)jsonReader.readObject(reader -> {
            ModelsSummary deserializedModelsSummary = new ModelsSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedModelsSummary.count = reader.getInt();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedModelsSummary.limit = reader.getInt();
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedModelsSummary.lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModelsSummary;
        });
    }
}

