/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.training;

import com.azure.ai.formrecognizer.FormRecognizerClient;
import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Constants;
import com.azure.ai.formrecognizer.implementation.CustomModelsImpl;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.ComposeRequest;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyOperationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyRequest;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAuthorizeModelCopyHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsComposeHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsCopyHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsTrainHeaders;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.OperationStatus;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.ai.formrecognizer.implementation.models.TrainSourceFilter;
import com.azure.ai.formrecognizer.models.CreateComposedModelOptions;
import com.azure.ai.formrecognizer.models.FormRecognizerErrorInformation;
import com.azure.ai.formrecognizer.models.FormRecognizerException;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.training.CustomModelTransforms;
import com.azure.ai.formrecognizer.training.FormTrainingClientBuilder;
import com.azure.ai.formrecognizer.training.models.AccountProperties;
import com.azure.ai.formrecognizer.training.models.CopyAuthorization;
import com.azure.ai.formrecognizer.training.models.CustomFormModel;
import com.azure.ai.formrecognizer.training.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.training.models.CustomFormModelStatus;
import com.azure.ai.formrecognizer.training.models.TrainingOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

@ServiceClient(builder=FormTrainingClientBuilder.class)
public final class FormTrainingClient {
    private static final ClientLogger LOGGER = new ClientLogger(FormTrainingClient.class);
    private final CustomModelsImpl customModelsImpl;
    private final FormRecognizerClientImpl service;

    FormTrainingClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.service = service;
        this.customModelsImpl = service.getCustomModels();
    }

    public FormRecognizerClient getFormRecognizerClient() {
        return new FormRecognizerClientBuilder().endpoint(this.service.getEndpoint()).pipeline(this.service.getHttpPipeline()).buildClient();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels) {
        return this.beginTraining(trainingFilesUrl, useTrainingLabels, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginTraining(String trainingFilesUrl, boolean useTrainingLabels, TrainingOptions trainingOptions, Context context) {
        return this.beginTrainingInternal(trainingFilesUrl, useTrainingLabels, trainingOptions, context);
    }

    private SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginTrainingInternal(String trainingFilesUrl, boolean useTrainingLabels, TrainingOptions trainingOptions, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)trainingFilesUrl)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'trainingFilesUrl' cannot be null."));
        }
        trainingOptions = trainingOptions == null ? new TrainingOptions() : trainingOptions;
        TrainSourceFilter trainSourceFilter = new TrainSourceFilter().setIncludeSubFolders(trainingOptions.getTrainingFileFilter() != null ? trainingOptions.getTrainingFileFilter().isSubfoldersIncluded() : false).setPrefix(trainingOptions.getTrainingFileFilter() != null ? trainingOptions.getTrainingFileFilter().getPrefix() : null);
        TrainRequest serviceTrainRequest = new TrainRequest().setSource(trainingFilesUrl).setSourceFilter(trainSourceFilter).setUseLabelFile(useTrainingLabels).setModelName(trainingOptions.getModelName());
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            try {
                ResponseBase<CustomModelsTrainHeaders, Void> trainWithResponse = this.customModelsImpl.trainWithResponse(serviceTrainRequest, context);
                return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((CustomModelsTrainHeaders)trainWithResponse.getDeserializedHeaders()).getLocation())));
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        }, this.createModelPollOperation(context), this.getCancellationIsNotSupported(), this.fetchModelResultOperation(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomFormModel getCustomModel(String modelId) {
        return (CustomFormModel)this.getCustomModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomFormModel> getCustomModelWithResponse(String modelId, Context context) {
        if (modelId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        try {
            Response<Model> response = this.customModelsImpl.getWithResponse(UUID.fromString(modelId), true, context);
            return new SimpleResponse(response, (Object)CustomModelTransforms.toCustomFormModel((Model)response.getValue()));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccountProperties getAccountProperties() {
        return (AccountProperties)this.getAccountPropertiesWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AccountProperties> getAccountPropertiesWithResponse(Context context) {
        Response<Models> response = this.customModelsImpl.getSummaryWithResponse(context);
        return new SimpleResponse(response, (Object)new AccountProperties(((Models)response.getValue()).getSummary().getCount(), ((Models)response.getValue()).getSummary().getLimit()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        this.deleteModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        try {
            return this.customModelsImpl.deleteWithResponse(UUID.fromString(modelId), context);
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomFormModelInfo> listCustomModels() {
        return this.listCustomModels(Context.NONE);
    }

    private PagedResponse<CustomFormModelInfo> listFirstPageModelInfo(Context context) {
        PagedResponse<ModelInfo> res = this.customModelsImpl.listSinglePage(context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), CustomModelTransforms.toCustomFormModelInfo(res.getValue()), (String)res.getContinuationToken(), null);
    }

    private PagedResponse<CustomFormModelInfo> listNextPageModelInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return null;
        }
        PagedResponse<ModelInfo> res = this.customModelsImpl.listNextSinglePage(nextPageLink, context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), CustomModelTransforms.toCustomFormModelInfo(res.getValue()), (String)res.getContinuationToken(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CustomFormModelInfo> listCustomModels(Context context) {
        return new PagedIterable(() -> this.listFirstPageModelInfo(context), nextLink -> this.listNextPageModelInfo((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target) {
        return this.beginCopyModelInternal(modelId, target, null, Context.NONE);
    }

    SyncPoller<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModelInternal(String modelId, CopyAuthorization target, Duration pollInterval, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        if (target == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'target' is required and cannot be null or empty"));
        }
        CopyRequest copyRequest = new CopyRequest().setTargetResourceId(target.getResourceId()).setTargetResourceRegion(target.getResourceRegion()).setCopyAuthorization(new CopyAuthorizationResult().setModelId(target.getModelId()).setAccessToken(target.getAccessToken()).setExpirationDateTimeTicks(target.getExpiresOn().toEpochSecond()));
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            ResponseBase<CustomModelsCopyHeaders, Void> copyWithResponse = this.customModelsImpl.copyWithResponse(UUID.fromString(modelId), copyRequest, context);
            return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((CustomModelsCopyHeaders)copyWithResponse.getDeserializedHeaders()).getOperationLocation())));
        }, this.createCopyPollOperation(modelId, context), this.getCancellationIsNotSupported(), this.fetchCopyModelResultOperation(modelId, target.getModelId(), context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModelInfo> beginCopyModel(String modelId, CopyAuthorization target, Duration pollInterval, Context context) {
        return this.beginCopyModelInternal(modelId, target, pollInterval, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization getCopyAuthorization(String resourceId, String resourceRegion) {
        return (CopyAuthorization)this.getCopyAuthorizationWithResponse(resourceId, resourceRegion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyAuthorization> getCopyAuthorizationWithResponse(String resourceId, String resourceRegion, Context context) {
        ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult> response = this.customModelsImpl.authorizeModelCopyWithResponse(context);
        CopyAuthorizationResult copyAuthorizationResult = (CopyAuthorizationResult)response.getValue();
        return new SimpleResponse(response, (Object)new CopyAuthorization(copyAuthorizationResult.getModelId(), copyAuthorizationResult.getAccessToken(), resourceId, resourceRegion, copyAuthorizationResult.getExpirationDateTimeTicks()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds) {
        return this.beginCreateComposedModel(modelIds, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModel(List<String> modelIds, CreateComposedModelOptions createComposedModelOptions, Context context) {
        return this.beginCreateComposedModelInternal(modelIds, createComposedModelOptions, context);
    }

    SyncPoller<FormRecognizerOperationResult, CustomFormModel> beginCreateComposedModelInternal(List<String> modelIds, CreateComposedModelOptions creatComposeModelOptions, Context context) {
        if (CoreUtils.isNullOrEmpty(modelIds)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelIds' is required and cannot be null or empty"));
        }
        creatComposeModelOptions = Utility.getCreateComposeModelOptions(creatComposeModelOptions);
        ComposeRequest composeRequest = new ComposeRequest().setModelIds(modelIds.stream().map(UUID::fromString).collect(Collectors.toList())).setModelName(creatComposeModelOptions.getModelName());
        return SyncPoller.createPoller((Duration)Constants.DEFAULT_POLL_INTERVAL, cxt -> {
            ResponseBase<CustomModelsComposeHeaders, Void> composeWithResponse = this.customModelsImpl.composeWithResponse(composeRequest, context);
            return new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)new FormRecognizerOperationResult(Utility.parseModelId(((CustomModelsComposeHeaders)composeWithResponse.getDeserializedHeaders()).getLocation())));
        }, this.createModelPollOperation(context), this.getCancellationIsNotSupported(), this.fetchModelResultOperation(context));
    }

    private BiFunction<PollingContext<FormRecognizerOperationResult>, PollResponse<FormRecognizerOperationResult>, FormRecognizerOperationResult> getCancellationIsNotSupported() {
        return (pollingContext, activationResponse) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, PollResponse<FormRecognizerOperationResult>> createModelPollOperation(Context context) {
        return pollingContext -> {
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            UUID modelUid = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
            try {
                Response<Model> modelSimpleResponse = this.customModelsImpl.getWithResponse(modelUid, true, context);
                return this.processTrainingModelResponse(modelSimpleResponse, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        };
    }

    private PollResponse<FormRecognizerOperationResult> processTrainingModelResponse(Response<Model> trainingModel, PollResponse<FormRecognizerOperationResult> trainingModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (((Model)trainingModel.getValue()).getModelInfo().getStatus()) {
            case CREATING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case READY: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case INVALID: {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new FormRecognizerException(String.format("Invalid model created with model Id %s", ((Model)trainingModel.getValue()).getModelInfo().getModelId()), ((Model)trainingModel.getValue()).getTrainResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((Model)trainingModel.getValue()).getModelInfo().getStatus().toString(), (boolean)true);
            }
        }
        return new PollResponse(status, (Object)((FormRecognizerOperationResult)trainingModelOperationResponse.getValue()));
    }

    private Function<PollingContext<FormRecognizerOperationResult>, CustomFormModel> fetchModelResultOperation(Context context) {
        return pollingContext -> {
            UUID modelUid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
            try {
                Response<Model> modelSimpleResponse = this.customModelsImpl.getWithResponse(modelUid, true, context);
                return CustomModelTransforms.toCustomFormModel((Model)modelSimpleResponse.getValue());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, PollResponse<FormRecognizerOperationResult>> createCopyPollOperation(String modelId, Context context) {
        return pollingContext -> {
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            UUID targetId = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
            try {
                Response<CopyOperationResult> modelSimpleResponse = this.customModelsImpl.getCopyResultWithResponse(UUID.fromString(modelId), targetId, context);
                return this.processCopyModelResponse(modelSimpleResponse, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse);
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        };
    }

    private PollResponse<FormRecognizerOperationResult> processCopyModelResponse(Response<CopyOperationResult> copyModel, PollResponse<FormRecognizerOperationResult> copyModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (((CopyOperationResult)copyModel.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new FormRecognizerException("Copy operation failed", ((CopyOperationResult)copyModel.getValue()).getCopyResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((CopyOperationResult)copyModel.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return new PollResponse(status, (Object)((FormRecognizerOperationResult)copyModelOperationResponse.getValue()));
    }

    private Function<PollingContext<FormRecognizerOperationResult>, CustomFormModelInfo> fetchCopyModelResultOperation(String modelId, String copyModelId, Context context) {
        return pollingContext -> {
            UUID resultUid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
            if (modelId == null) {
                LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'modelId' cannot be null."));
            }
            try {
                CopyOperationResult copyOperationResult = (CopyOperationResult)this.customModelsImpl.getCopyResultWithResponse(UUID.fromString(modelId), resultUid, context).getValue();
                return new CustomFormModelInfo(copyModelId, copyOperationResult.getStatus() == OperationStatus.SUCCEEDED ? CustomFormModelStatus.READY : CustomFormModelStatus.fromString(copyOperationResult.getStatus().toString()), copyOperationResult.getCreatedDateTime(), copyOperationResult.getLastUpdatedDateTime());
            }
            catch (ErrorResponseException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
            }
        };
    }
}

