// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsBuildModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsComposeModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsCopyModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentModelsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentAnalysisFeature;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in DocumentModels.
 */
public final class DocumentModelsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DocumentModelsService service;

    /**
     * The service client containing this operation class.
     */
    private final FormRecognizerClientImpl client;

    /**
     * Initializes an instance of DocumentModelsImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    DocumentModelsImpl(FormRecognizerClientImpl client) {
        this.service
            = RestProxy.create(DocumentModelsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for FormRecognizerClientDocumentModels to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}/formrecognizer")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface DocumentModelsService {
        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> analyzeDocumentNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> analyzeRequest,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> analyzeRequest,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData analyzeRequest,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData analyzeRequest,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData analyzeRequest,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> analyzeDocumentNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData analyzeRequest,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("text/html") String analyzeRequest, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("text/html") String analyzeRequest, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(
            @HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("pages") String pages, @QueryParam("locale") String locale,
            @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("text/html") String analyzeRequest, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> analyzeDocumentNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("pages") String pages,
            @QueryParam("locale") String locale, @QueryParam("stringIndexType") StringIndexType stringIndexType,
            @QueryParam("api-version") String apiVersion, @QueryParam("features") String features,
            @BodyParam("text/html") String analyzeRequest, @HeaderParam("Accept") String accept, Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeResultOperation>> getAnalyzeResult(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @PathParam("resultId") String resultId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<AnalyzeResultOperation> getAnalyzeResultSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @PathParam("resultId") String resultId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModel(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BuildDocumentModelRequest buildRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> buildModelNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BuildDocumentModelRequest buildRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsBuildModelHeaders, Void> buildModelSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BuildDocumentModelRequest buildRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> buildModelNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") BuildDocumentModelRequest buildRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModel(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> composeModelNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsComposeModelHeaders, Void> composeModelSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> composeModelNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<CopyAuthorization>> authorizeModelCopy(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AuthorizeCopyRequest authorizeCopyRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<CopyAuthorization> authorizeModelCopySync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AuthorizeCopyRequest authorizeCopyRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelTo(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CopyAuthorization copyToRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> copyModelToNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CopyAuthorization copyToRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<DocumentModelsCopyModelToHeaders, Void> copyModelToSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CopyAuthorization copyToRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> copyModelToNoCustomHeadersSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CopyAuthorization copyToRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/documentModels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentModelsResponse>> listModels(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/documentModels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentModelsResponse> listModelsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<DocumentModelDetails>> getModel(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<DocumentModelDetails> getModelSync(@HostParam("endpoint") String endpoint,
            @PathParam("modelId") String modelId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> deleteModel(@HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteModelSync(@HostParam("endpoint") String endpoint, @PathParam("modelId") String modelId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentModelsResponse>> listModelsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentModelsResponse> listModelsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return FluxUtil.withContext(context -> analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType,
            features, analyzeRequest, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features,
                analyzeRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest,
        Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features,
                analyzeRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest,
                Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest,
        Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest,
                context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale,
            stringIndexType, features, analyzeRequest, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest,
        Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeadersSync(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType,
                features, analyzeRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType,
                features, analyzeRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features,
                analyzeRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        AnalyzeDocumentRequest analyzeRequest, Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features,
                analyzeRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale,
            stringIndexType, features, analyzeRequest, contentLength, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, accept,
            context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features,
                analyzeRequest, contentLength),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features,
                analyzeRequest, contentLength, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType,
            pages, locale, stringIndexType, features, analyzeRequest, contentLength, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength,
            accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale,
                stringIndexType, features, analyzeRequest, contentLength),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale,
                stringIndexType, features, analyzeRequest, contentLength, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale,
            stringIndexType, features, analyzeRequest, contentLength, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, accept,
            context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, accept,
            context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features,
                analyzeRequest, contentLength),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features,
                analyzeRequest, contentLength, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, contentType, pages, locale, stringIndexType, features,
                analyzeRequest, contentLength, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength, Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, contentType, pages, locale, stringIndexType, features,
                analyzeRequest, contentLength, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType,
            pages, locale, stringIndexType, features, analyzeRequest, contentLength, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength,
            accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(String modelId, ContentType contentType,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        BinaryData analyzeRequest, Long contentLength, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeadersSync(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength,
            accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale,
                stringIndexType, features, analyzeRequest, contentLength),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale,
                stringIndexType, features, analyzeRequest, contentLength, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, contentType, pages, locale, stringIndexType,
                features, analyzeRequest, contentLength, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId,
        ContentType contentType, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, contentType, pages, locale, stringIndexType,
                features, analyzeRequest, contentLength, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return FluxUtil.withContext(context -> analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType,
            features, analyzeRequest, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
        String modelId, String pages, String locale, StringIndexType stringIndexType,
        List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId,
        String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features,
        String analyzeRequest, Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType,
            this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features,
                analyzeRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest,
        Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features,
                analyzeRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest,
                Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest,
        Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest,
                context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale,
            stringIndexType, features, analyzeRequest, context));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest,
        Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(String modelId, String pages, String locale,
        StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest,
        Context context) {
        final String accept = "application/json";
        String featuresConverted = (features == null)
            ? null
            : features.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeadersSync(this.client.getEndpoint(), modelId, pages, locale,
            stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, accept, context);
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType,
                features, analyzeRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest,
        Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType,
                features, analyzeRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features,
                analyzeRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * 
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     * (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param features List of optional analysis features.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages,
        String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest,
        Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features,
                analyzeRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Gets the result of document analysis.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeResultWithResponseAsync(String modelId, String resultId) {
        return FluxUtil.withContext(context -> getAnalyzeResultWithResponseAsync(modelId, resultId, context));
    }

    /**
     * Gets the result of document analysis.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeResultWithResponseAsync(String modelId, String resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeResult(this.client.getEndpoint(), modelId, resultId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Gets the result of document analysis.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeResultAsync(String modelId, String resultId) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the result of document analysis.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeResultAsync(String modelId, String resultId, Context context) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the result of document analysis.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getAnalyzeResultWithResponse(String modelId, String resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeResultSync(this.client.getEndpoint(), modelId, resultId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Gets the result of document analysis.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeResultOperation getAnalyzeResult(String modelId, String resultId) {
        return getAnalyzeResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>>
        buildModelWithResponseAsync(BuildDocumentModelRequest buildRequest) {
        return FluxUtil.withContext(context -> buildModelWithResponseAsync(buildRequest, context));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>>
        buildModelWithResponseAsync(BuildDocumentModelRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildModel(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept,
            context);
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsBuildModelHeaders, Void>
        buildModelWithResponse(BuildDocumentModelRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildModelSync(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, accept,
            context);
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create(Duration.ofSeconds(1), () -> this.buildModelWithResponseAsync(buildRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelAsync(BuildDocumentModelRequest buildRequest,
        Context context) {
        return PollerFlux.create(Duration.ofSeconds(1), () -> this.buildModelWithResponseAsync(buildRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModel(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildModelWithResponse(buildRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModel(BuildDocumentModelRequest buildRequest, Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1), () -> this.buildModelWithResponse(buildRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> buildModelNoCustomHeadersWithResponseAsync(BuildDocumentModelRequest buildRequest) {
        return FluxUtil.withContext(context -> buildModelNoCustomHeadersWithResponseAsync(buildRequest, context));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> buildModelNoCustomHeadersWithResponseAsync(BuildDocumentModelRequest buildRequest,
        Context context) {
        final String accept = "application/json";
        return service.buildModelNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest,
            accept, context);
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> buildModelNoCustomHeadersWithResponse(BuildDocumentModelRequest buildRequest,
        Context context) {
        final String accept = "application/json";
        return service.buildModelNoCustomHeadersSync(this.client.getEndpoint(), this.client.getApiVersion(),
            buildRequest, accept, context);
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData>
        beginBuildModelNoCustomHeadersAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.buildModelNoCustomHeadersWithResponseAsync(buildRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData>
        beginBuildModelNoCustomHeadersAsync(BuildDocumentModelRequest buildRequest, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.buildModelNoCustomHeadersWithResponseAsync(buildRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModelNoCustomHeaders(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildModelNoCustomHeadersWithResponse(buildRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * 
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModelNoCustomHeaders(BuildDocumentModelRequest buildRequest,
        Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildModelNoCustomHeadersWithResponse(buildRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>>
        composeModelWithResponseAsync(ComposeDocumentModelRequest composeRequest) {
        return FluxUtil.withContext(context -> composeModelWithResponseAsync(composeRequest, context));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>>
        composeModelWithResponseAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        final String accept = "application/json";
        return service.composeModel(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, accept,
            context);
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsComposeModelHeaders, Void>
        composeModelWithResponse(ComposeDocumentModelRequest composeRequest, Context context) {
        final String accept = "application/json";
        return service.composeModelSync(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, accept,
            context);
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create(Duration.ofSeconds(1), () -> this.composeModelWithResponseAsync(composeRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(ComposeDocumentModelRequest composeRequest,
        Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.composeModelWithResponseAsync(composeRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.composeModelWithResponse(composeRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(ComposeDocumentModelRequest composeRequest,
        Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.composeModelWithResponse(composeRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>>
        composeModelNoCustomHeadersWithResponseAsync(ComposeDocumentModelRequest composeRequest) {
        return FluxUtil.withContext(context -> composeModelNoCustomHeadersWithResponseAsync(composeRequest, context));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> composeModelNoCustomHeadersWithResponseAsync(ComposeDocumentModelRequest composeRequest,
        Context context) {
        final String accept = "application/json";
        return service.composeModelNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            composeRequest, accept, context);
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> composeModelNoCustomHeadersWithResponse(ComposeDocumentModelRequest composeRequest,
        Context context) {
        final String accept = "application/json";
        return service.composeModelNoCustomHeadersSync(this.client.getEndpoint(), this.client.getApiVersion(),
            composeRequest, accept, context);
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData>
        beginComposeModelNoCustomHeadersAsync(ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.composeModelNoCustomHeadersWithResponseAsync(composeRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData>
        beginComposeModelNoCustomHeadersAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.composeModelNoCustomHeadersWithResponseAsync(composeRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData>
        beginComposeModelNoCustomHeaders(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.composeModelNoCustomHeadersWithResponse(composeRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * 
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData>
        beginComposeModelNoCustomHeaders(ComposeDocumentModelRequest composeRequest, Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.composeModelNoCustomHeadersWithResponse(composeRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>>
        authorizeModelCopyWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return FluxUtil.withContext(context -> authorizeModelCopyWithResponseAsync(authorizeCopyRequest, context));
    }

    /**
     * Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>>
        authorizeModelCopyWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        final String accept = "application/json";
        return service.authorizeModelCopy(this.client.getEndpoint(), this.client.getApiVersion(), authorizeCopyRequest,
            accept, context);
    }

    /**
     * Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return authorizeModelCopyWithResponseAsync(authorizeCopyRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return authorizeModelCopyWithResponseAsync(authorizeCopyRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CopyAuthorization> authorizeModelCopyWithResponse(AuthorizeCopyRequest authorizeCopyRequest,
        Context context) {
        final String accept = "application/json";
        return service.authorizeModelCopySync(this.client.getEndpoint(), this.client.getApiVersion(),
            authorizeCopyRequest, accept, context);
    }

    /**
     * Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyAuthorization authorizeModelCopy(AuthorizeCopyRequest authorizeCopyRequest) {
        return authorizeModelCopyWithResponse(authorizeCopyRequest, Context.NONE).getValue();
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelToWithResponseAsync(String modelId,
        CopyAuthorization copyToRequest) {
        return FluxUtil.withContext(context -> copyModelToWithResponseAsync(modelId, copyToRequest, context));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelToWithResponseAsync(String modelId,
        CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyModelTo(this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest,
            accept, context);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<DocumentModelsCopyModelToHeaders, Void> copyModelToWithResponse(String modelId,
        CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyModelToSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest,
            accept, context);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, CopyAuthorization copyToRequest) {
        return PollerFlux.create(Duration.ofSeconds(1), () -> this.copyModelToWithResponseAsync(modelId, copyToRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, CopyAuthorization copyToRequest,
        Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponse(modelId, copyToRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest,
        Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponse(modelId, copyToRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> copyModelToNoCustomHeadersWithResponseAsync(String modelId,
        CopyAuthorization copyToRequest) {
        return FluxUtil
            .withContext(context -> copyModelToNoCustomHeadersWithResponseAsync(modelId, copyToRequest, context));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> copyModelToNoCustomHeadersWithResponseAsync(String modelId,
        CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyModelToNoCustomHeaders(this.client.getEndpoint(), modelId, this.client.getApiVersion(),
            copyToRequest, accept, context);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> copyModelToNoCustomHeadersWithResponse(String modelId, CopyAuthorization copyToRequest,
        Context context) {
        final String accept = "application/json";
        return service.copyModelToNoCustomHeadersSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(),
            copyToRequest, accept, context);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToNoCustomHeadersAsync(String modelId,
        CopyAuthorization copyToRequest) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyModelToNoCustomHeadersWithResponseAsync(modelId, copyToRequest),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToNoCustomHeadersAsync(String modelId,
        CopyAuthorization copyToRequest, Context context) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyModelToNoCustomHeadersWithResponseAsync(modelId, copyToRequest, context),
            new DefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelToNoCustomHeaders(String modelId,
        CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyModelToNoCustomHeadersWithResponse(modelId, copyToRequest, Context.NONE),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(Context.NONE)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelToNoCustomHeaders(String modelId,
        CopyAuthorization copyToRequest, Context context) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyModelToNoCustomHeadersWithResponse(modelId, copyToRequest, context),
            new SyncDefaultPollingStrategy<>(new PollingStrategyOptions(this.client.getHttpPipeline())
                .setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint()))
                .setContext(context)),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * List all document models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsSinglePageAsync() {
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listModels(this.client.getEndpoint(), this.client.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List all document models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsSinglePageAsync(Context context) {
        final String accept = "application/json";
        return service.listModels(this.client.getEndpoint(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * List all document models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listModelsAsync() {
        return new PagedFlux<>(() -> listModelsSinglePageAsync(), nextLink -> listModelsNextSinglePageAsync(nextLink));
    }

    /**
     * List all document models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listModelsAsync(Context context) {
        return new PagedFlux<>(() -> listModelsSinglePageAsync(context),
            nextLink -> listModelsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all document models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsSinglePage() {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res
            = service.listModelsSync(this.client.getEndpoint(), this.client.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List all document models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsSinglePage(Context context) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res
            = service.listModelsSync(this.client.getEndpoint(), this.client.getApiVersion(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * List all document models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listModels() {
        return new PagedIterable<>(() -> listModelsSinglePage(Context.NONE),
            nextLink -> listModelsNextSinglePage(nextLink));
    }

    /**
     * List all document models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listModels(Context context) {
        return new PagedIterable<>(() -> listModelsSinglePage(context),
            nextLink -> listModelsNextSinglePage(nextLink, context));
    }

    /**
     * Gets detailed document model information.
     * 
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getModelWithResponseAsync(String modelId) {
        return FluxUtil.withContext(context -> getModelWithResponseAsync(modelId, context));
    }

    /**
     * Gets detailed document model information.
     * 
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getModelWithResponseAsync(String modelId, Context context) {
        final String accept = "application/json";
        return service.getModel(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets detailed document model information.
     * 
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModelAsync(String modelId) {
        return getModelWithResponseAsync(modelId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets detailed document model information.
     * 
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModelAsync(String modelId, Context context) {
        return getModelWithResponseAsync(modelId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets detailed document model information.
     * 
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DocumentModelDetails> getModelWithResponse(String modelId, Context context) {
        final String accept = "application/json";
        return service.getModelSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets detailed document model information.
     * 
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentModelDetails getModel(String modelId) {
        return getModelWithResponse(modelId, Context.NONE).getValue();
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId) {
        return FluxUtil.withContext(context -> deleteModelWithResponseAsync(modelId, context));
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId, Context context) {
        final String accept = "application/json";
        return service.deleteModel(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept, context);
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId) {
        return deleteModelWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId, Context context) {
        return deleteModelWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        final String accept = "application/json";
        return service.deleteModelSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        deleteModelWithResponse(modelId, Context.NONE);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listModelsNext(nextLink, this.client.getEndpoint(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.listModelsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsNextSinglePage(String nextLink) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res
            = service.listModelsNextSync(nextLink, this.client.getEndpoint(), accept, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res
            = service.listModelsNextSync(nextLink, this.client.getEndpoint(), accept, context);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            res.getValue().getValue(), res.getValue().getNextLink(), null);
    }
}
