// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

/**
 * Content type for upload.
 */
public enum ContentType {
    /**
     * Content Type 'application/octet-stream'.
     */
    APPLICATION_OCTET_STREAM("application/octet-stream"),

    /**
     * Content Type 'application/pdf'.
     */
    APPLICATION_PDF("application/pdf"),

    /**
     * Content Type 'application/vnd.openxmlformats-officedocument.presentationml.presentation'.
     */
    APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_PRESENTATIONML_PRESENTATION(
        "application/vnd.openxmlformats-officedocument.presentationml.presentation"),

    /**
     * Content Type 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'.
     */
    APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_SPREADSHEETML_SHEET(
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),

    /**
     * Content Type 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'.
     */
    APPLICATION_VND_OPENXMLFORMATS_OFFICEDOCUMENT_WORDPROCESSINGML_DOCUMENT(
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document"),

    /**
     * Content Type 'image/bmp'.
     */
    IMAGE_BMP("image/bmp"),

    /**
     * Content Type 'image/heif'.
     */
    IMAGE_HEIF("image/heif"),

    /**
     * Content Type 'image/jpeg'.
     */
    IMAGE_JPEG("image/jpeg"),

    /**
     * Content Type 'image/png'.
     */
    IMAGE_PNG("image/png"),

    /**
     * Content Type 'image/tiff'.
     */
    IMAGE_TIFF("image/tiff");

    /**
     * The actual serialized value for a ContentType instance.
     */
    private final String value;

    ContentType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ContentType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ContentType object, or null if unable to parse.
     */
    public static ContentType fromString(String value) {
        if (value == null) {
            return null;
        }
        ContentType[] items = ContentType.values();
        for (ContentType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
