// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Content and layout elements extracted from a page from the input.
 */
@Fluent
public final class DocumentPage implements JsonSerializable<DocumentPage> {
    /*
     * 1-based page number in the input document.
     */
    private final int pageNumber;

    /*
     * The general orientation of the content in clockwise direction, measured in degrees between (-180, 180].
     */
    private Float angle;

    /*
     * The width of the image/PDF in pixels/inches, respectively.
     */
    private Float width;

    /*
     * The height of the image/PDF in pixels/inches, respectively.
     */
    private Float height;

    /*
     * The unit used by the width, height, and polygon properties. For images, the unit is "pixel". For PDF, the unit is
     * "inch".
     */
    private LengthUnit unit;

    /*
     * Location of the page in the reading order concatenated content.
     */
    private final List<DocumentSpan> spans;

    /*
     * Extracted words from the page.
     */
    private List<DocumentWord> words;

    /*
     * Extracted selection marks from the page.
     */
    private List<DocumentSelectionMark> selectionMarks;

    /*
     * Extracted lines from the page, potentially containing both textual and visual elements.
     */
    private List<DocumentLine> lines;

    /*
     * Extracted barcodes from the page.
     */
    private List<DocumentBarcode> barcodes;

    /*
     * Extracted formulas from the page.
     */
    private List<DocumentFormula> formulas;

    /**
     * Creates an instance of DocumentPage class.
     * 
     * @param pageNumber the pageNumber value to set.
     * @param spans the spans value to set.
     */
    public DocumentPage(int pageNumber, List<DocumentSpan> spans) {
        this.pageNumber = pageNumber;
        this.spans = spans;
    }

    /**
     * Get the pageNumber property: 1-based page number in the input document.
     * 
     * @return the pageNumber value.
     */
    public int getPageNumber() {
        return this.pageNumber;
    }

    /**
     * Get the angle property: The general orientation of the content in clockwise direction, measured in degrees
     * between (-180, 180].
     * 
     * @return the angle value.
     */
    public Float getAngle() {
        return this.angle;
    }

    /**
     * Set the angle property: The general orientation of the content in clockwise direction, measured in degrees
     * between (-180, 180].
     * 
     * @param angle the angle value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setAngle(Float angle) {
        this.angle = angle;
        return this;
    }

    /**
     * Get the width property: The width of the image/PDF in pixels/inches, respectively.
     * 
     * @return the width value.
     */
    public Float getWidth() {
        return this.width;
    }

    /**
     * Set the width property: The width of the image/PDF in pixels/inches, respectively.
     * 
     * @param width the width value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setWidth(Float width) {
        this.width = width;
        return this;
    }

    /**
     * Get the height property: The height of the image/PDF in pixels/inches, respectively.
     * 
     * @return the height value.
     */
    public Float getHeight() {
        return this.height;
    }

    /**
     * Set the height property: The height of the image/PDF in pixels/inches, respectively.
     * 
     * @param height the height value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setHeight(Float height) {
        this.height = height;
        return this;
    }

    /**
     * Get the unit property: The unit used by the width, height, and polygon properties. For images, the unit is
     * "pixel". For PDF, the unit is "inch".
     * 
     * @return the unit value.
     */
    public LengthUnit getUnit() {
        return this.unit;
    }

    /**
     * Set the unit property: The unit used by the width, height, and polygon properties. For images, the unit is
     * "pixel". For PDF, the unit is "inch".
     * 
     * @param unit the unit value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setUnit(LengthUnit unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the spans property: Location of the page in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the words property: Extracted words from the page.
     * 
     * @return the words value.
     */
    public List<DocumentWord> getWords() {
        return this.words;
    }

    /**
     * Set the words property: Extracted words from the page.
     * 
     * @param words the words value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setWords(List<DocumentWord> words) {
        this.words = words;
        return this;
    }

    /**
     * Get the selectionMarks property: Extracted selection marks from the page.
     * 
     * @return the selectionMarks value.
     */
    public List<DocumentSelectionMark> getSelectionMarks() {
        return this.selectionMarks;
    }

    /**
     * Set the selectionMarks property: Extracted selection marks from the page.
     * 
     * @param selectionMarks the selectionMarks value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setSelectionMarks(List<DocumentSelectionMark> selectionMarks) {
        this.selectionMarks = selectionMarks;
        return this;
    }

    /**
     * Get the lines property: Extracted lines from the page, potentially containing both textual and visual elements.
     * 
     * @return the lines value.
     */
    public List<DocumentLine> getLines() {
        return this.lines;
    }

    /**
     * Set the lines property: Extracted lines from the page, potentially containing both textual and visual elements.
     * 
     * @param lines the lines value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setLines(List<DocumentLine> lines) {
        this.lines = lines;
        return this;
    }

    /**
     * Get the barcodes property: Extracted barcodes from the page.
     * 
     * @return the barcodes value.
     */
    public List<DocumentBarcode> getBarcodes() {
        return this.barcodes;
    }

    /**
     * Set the barcodes property: Extracted barcodes from the page.
     * 
     * @param barcodes the barcodes value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setBarcodes(List<DocumentBarcode> barcodes) {
        this.barcodes = barcodes;
        return this;
    }

    /**
     * Get the formulas property: Extracted formulas from the page.
     * 
     * @return the formulas value.
     */
    public List<DocumentFormula> getFormulas() {
        return this.formulas;
    }

    /**
     * Set the formulas property: Extracted formulas from the page.
     * 
     * @param formulas the formulas value to set.
     * @return the DocumentPage object itself.
     */
    public DocumentPage setFormulas(List<DocumentFormula> formulas) {
        this.formulas = formulas;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("pageNumber", this.pageNumber);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("angle", this.angle);
        jsonWriter.writeNumberField("width", this.width);
        jsonWriter.writeNumberField("height", this.height);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("words", this.words, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("selectionMarks", this.selectionMarks,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("lines", this.lines, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("barcodes", this.barcodes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("formulas", this.formulas, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentPage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentPage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentPage.
     */
    public static DocumentPage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean pageNumberFound = false;
            int pageNumber = 0;
            boolean spansFound = false;
            List<DocumentSpan> spans = null;
            Float angle = null;
            Float width = null;
            Float height = null;
            LengthUnit unit = null;
            List<DocumentWord> words = null;
            List<DocumentSelectionMark> selectionMarks = null;
            List<DocumentLine> lines = null;
            List<DocumentBarcode> barcodes = null;
            List<DocumentFormula> formulas = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("pageNumber".equals(fieldName)) {
                    pageNumber = reader.getInt();
                    pageNumberFound = true;
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                } else if ("angle".equals(fieldName)) {
                    angle = reader.getNullable(JsonReader::getFloat);
                } else if ("width".equals(fieldName)) {
                    width = reader.getNullable(JsonReader::getFloat);
                } else if ("height".equals(fieldName)) {
                    height = reader.getNullable(JsonReader::getFloat);
                } else if ("unit".equals(fieldName)) {
                    unit = LengthUnit.fromString(reader.getString());
                } else if ("words".equals(fieldName)) {
                    words = reader.readArray(reader1 -> DocumentWord.fromJson(reader1));
                } else if ("selectionMarks".equals(fieldName)) {
                    selectionMarks = reader.readArray(reader1 -> DocumentSelectionMark.fromJson(reader1));
                } else if ("lines".equals(fieldName)) {
                    lines = reader.readArray(reader1 -> DocumentLine.fromJson(reader1));
                } else if ("barcodes".equals(fieldName)) {
                    barcodes = reader.readArray(reader1 -> DocumentBarcode.fromJson(reader1));
                } else if ("formulas".equals(fieldName)) {
                    formulas = reader.readArray(reader1 -> DocumentFormula.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            if (pageNumberFound && spansFound) {
                DocumentPage deserializedDocumentPage = new DocumentPage(pageNumber, spans);
                deserializedDocumentPage.angle = angle;
                deserializedDocumentPage.width = width;
                deserializedDocumentPage.height = height;
                deserializedDocumentPage.unit = unit;
                deserializedDocumentPage.words = words;
                deserializedDocumentPage.selectionMarks = selectionMarks;
                deserializedDocumentPage.lines = lines;
                deserializedDocumentPage.barcodes = barcodes;
                deserializedDocumentPage.formulas = formulas;

                return deserializedDocumentPage;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!pageNumberFound) {
                missingProperties.add("pageNumber");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
