// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Error response object.
 */
@Immutable
public final class ErrorResponse implements JsonSerializable<ErrorResponse> {
    /*
     * Error info.
     */
    private final Error error;

    /**
     * Creates an instance of ErrorResponse class.
     * 
     * @param error the error value to set.
     */
    public ErrorResponse(Error error) {
        this.error = error;
    }

    /**
     * Get the error property: Error info.
     * 
     * @return the error value.
     */
    public Error getError() {
        return this.error;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ErrorResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ErrorResponse if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ErrorResponse.
     */
    public static ErrorResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean errorFound = false;
            Error error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    errorFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (errorFound) {
                return new ErrorResponse(error);
            }
            throw new IllegalStateException("Missing required property: error");
        });
    }
}
